/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution.complexity;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public class Expressions {
    private static final Map<String, Integer> OPERATOR_PRECEDENCE;
    private static final String LOOK_AROUND_PATTERN = "((?<=%1$s)|(?=%1$s))";
    private static final String DELIMITER;

    public static Double eval(String expression, Map<String, Object> variables) {
        Stack<String> ops = new Stack<String>();
        Stack<Double> vals = new Stack<Double>();
        ArrayDeque<String> tokens = new ArrayDeque<String>(Arrays.asList(expression.split(DELIMITER)));
        block2: while (!tokens.isEmpty()) {
            String s = (String)tokens.poll();
            if (s.trim().isEmpty()) continue;
            if (!OPERATOR_PRECEDENCE.containsKey(s)) {
                Object var = variables.get(s);
                if (var instanceof Number) {
                    vals.push(((Number)var).doubleValue());
                    continue;
                }
                try {
                    vals.push(Double.parseDouble(var instanceof String ? var.toString() : s));
                    continue;
                }
                catch (NumberFormatException e) {
                    if (var == null) {
                        throw new IllegalArgumentException("Undefined variable '" + s + "'");
                    }
                    throw e;
                }
            }
            while (true) {
                if (ops.isEmpty() || s.equals("(") || OPERATOR_PRECEDENCE.get(s) > OPERATOR_PRECEDENCE.get(ops.peek())) {
                    ops.push(s);
                    continue block2;
                }
                String op = (String)ops.pop();
                if (op.equals("(")) {
                    if (s.equals(")")) continue block2;
                    throw new IllegalArgumentException("Unbalanced parentheses: ')' expected");
                }
                double val2 = (Double)vals.pop();
                double val1 = (Double)vals.pop();
                vals.push(Expressions.eval(op, val1, val2));
            }
        }
        while (!ops.isEmpty()) {
            String op = (String)ops.pop();
            double val2 = (Double)vals.pop();
            double val1 = (Double)vals.pop();
            vals.push(Expressions.eval(op, val1, val2));
        }
        Double result = (Double)vals.pop();
        if (!vals.isEmpty()) {
            throw new IllegalArgumentException("Missing operator");
        }
        return result;
    }

    private static double eval(String op, double val1, double val2) {
        if (op.equals("+")) {
            return val1 + val2;
        }
        if (op.equals("-")) {
            return val1 - val2;
        }
        if (op.equals("/")) {
            return val1 / val2;
        }
        if (op.equals("*")) {
            return val1 * val2;
        }
        throw new IllegalArgumentException("Invalid operator '" + op + "'");
    }

    static {
        DELIMITER = String.format(LOOK_AROUND_PATTERN, "[\\Q()+-*/\\E]|\\s");
        TreeMap<String, Integer> precedence = new TreeMap<String, Integer>();
        precedence.put("(", 0);
        precedence.put(")", 0);
        precedence.put("+", 1);
        precedence.put("-", 1);
        precedence.put("*", 2);
        precedence.put("/", 2);
        OPERATOR_PRECEDENCE = Collections.unmodifiableMap(precedence);
    }
}

