/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLTypeReference;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.generator.mapping.TypeMappingEnvironment;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.AnnotatedType;
import java.util.Set;

public abstract class CachingMapper<O extends GraphQLOutputType, I extends GraphQLInputType>
implements TypeMapper {
    @Override
    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, Set<Class<? extends TypeMapper>> mappersToSkip, TypeMappingEnvironment env) {
        String typeName = this.getTypeName(javaType, env.buildContext);
        if (env.buildContext.typeCache.contains(typeName)) {
            return new GraphQLTypeReference(typeName);
        }
        env.buildContext.typeCache.register(typeName);
        return this.toGraphQLType(typeName, javaType, env);
    }

    @Override
    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, Set<Class<? extends TypeMapper>> mappersToSkip, TypeMappingEnvironment env) {
        String typeName = this.getInputTypeName(javaType, env.buildContext);
        if (env.buildContext.typeCache.contains(typeName)) {
            return new GraphQLTypeReference(typeName);
        }
        env.buildContext.typeCache.register(typeName);
        return this.toGraphQLInputType(typeName, javaType, env);
    }

    protected abstract O toGraphQLType(String var1, AnnotatedType var2, TypeMappingEnvironment var3);

    protected abstract I toGraphQLInputType(String var1, AnnotatedType var2, TypeMappingEnvironment var3);

    protected String getTypeName(AnnotatedType type, BuildContext buildContext) {
        return this.getTypeName(type, this.getTypeArguments(0), buildContext.typeInfoGenerator, buildContext.messageBundle);
    }

    protected String getInputTypeName(AnnotatedType type, BuildContext buildContext) {
        return this.getTypeName(type, this.getTypeArguments(1), buildContext.typeInfoGenerator, buildContext.messageBundle);
    }

    private String getTypeName(AnnotatedType javaType, AnnotatedType graphQLType, TypeInfoGenerator typeInfoGenerator, MessageBundle messageBundle) {
        if (ClassUtils.isSuperClass(GraphQLScalarType.class, graphQLType)) {
            return typeInfoGenerator.generateScalarTypeName(javaType, messageBundle);
        }
        if (ClassUtils.isSuperClass(GraphQLEnumType.class, graphQLType)) {
            return typeInfoGenerator.generateEnumTypeName(javaType, messageBundle);
        }
        if (ClassUtils.isSuperClass(GraphQLInputType.class, graphQLType)) {
            return typeInfoGenerator.generateInputTypeName(javaType, messageBundle);
        }
        return typeInfoGenerator.generateTypeName(javaType, messageBundle);
    }

    private AnnotatedType getTypeArguments(int index) {
        return GenericTypeReflector.getTypeParameter((AnnotatedType)this.getClass().getAnnotatedSuperclass(), CachingMapper.class.getTypeParameters()[index]);
    }
}

