/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import io.leangen.graphql.execution.InvocationContext;
import io.leangen.graphql.execution.ResolverInterceptor;
import io.leangen.graphql.execution.ResolverInterceptorFactory;
import io.leangen.graphql.execution.ResolverInterceptorFactoryParams;
import io.leangen.graphql.generator.mapping.common.AbstractTypeSubstitutingMapper;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.util.Collections;
import java.util.List;

public class VoidToBooleanTypeAdapter
extends AbstractTypeSubstitutingMapper<Boolean>
implements ResolverInterceptorFactory {
    private static final ReturnTrue returnTrue = new ReturnTrue();

    @Override
    public boolean supports(AnnotatedElement element, AnnotatedType type) {
        return this.isVoid(type);
    }

    @Override
    public List<ResolverInterceptor> getInterceptors(ResolverInterceptorFactoryParams params) {
        if (this.isVoid(params.getResolver().getReturnType())) {
            return Collections.singletonList(returnTrue);
        }
        return Collections.emptyList();
    }

    private boolean isVoid(AnnotatedType type) {
        return type.getType() == Void.TYPE || type.getType() == Void.class;
    }

    private static class ReturnTrue
    implements ResolverInterceptor {
        private ReturnTrue() {
        }

        @Override
        public Object aroundInvoke(InvocationContext context, ResolverInterceptor.Continuation continuation) throws Exception {
            continuation.proceed(context);
            return true;
        }
    }
}

