/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.core;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionStepInfo;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.generator.mapping.SchemaTransformer;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.generator.mapping.TypeMappingEnvironment;
import io.leangen.graphql.generator.mapping.common.AbstractTypeSubstitutingMapper;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PublisherAdapter<T>
extends AbstractTypeSubstitutingMapper<Object>
implements SchemaTransformer,
OutputConverter<Publisher<T>, Object> {
    private final Executor executor;

    public PublisherAdapter() {
        this(Runnable::run);
    }

    public PublisherAdapter(Executor executor) {
        this.executor = executor;
    }

    @Override
    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, Set<Class<? extends TypeMapper>> mappersToSkip, TypeMappingEnvironment env) {
        throw new UnsupportedOperationException(ClassUtils.getRawType(javaType.getType()).getSimpleName() + " can not be used as an input type");
    }

    @Override
    public AnnotatedType getSubstituteType(AnnotatedType original) {
        AnnotatedType innerType = GenericTypeReflector.getTypeParameter((AnnotatedType)original, Publisher.class.getTypeParameters()[0]);
        return TypeFactory.parameterizedAnnotatedClass(List.class, (Annotation[])original.getAnnotations(), (AnnotatedType[])new AnnotatedType[]{innerType});
    }

    @Override
    public GraphQLFieldDefinition transformField(GraphQLFieldDefinition field, Operation operation, OperationMapper operationMapper, BuildContext buildContext) {
        if (operation.getOperationType() == OperationDefinition.Operation.SUBSCRIPTION) {
            return field.transform(builder -> builder.type(this.unwrapList(field.getType())));
        }
        return field;
    }

    @Override
    public Object convertOutput(Publisher<T> original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        if (resolutionEnvironment.dataFetchingEnvironment.getParentType() == resolutionEnvironment.dataFetchingEnvironment.getGraphQLSchema().getSubscriptionType()) {
            return original;
        }
        return this.convertOutputForNonSubscription(original, type, resolutionEnvironment);
    }

    protected Object convertOutputForNonSubscription(Publisher<T> original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        return this.collect(original, resolutionEnvironment.dataFetchingEnvironment.getExecutionStepInfo());
    }

    @Override
    public boolean supports(AnnotatedElement element, AnnotatedType type) {
        return ClassUtils.isSuperClass(Publisher.class, type);
    }

    private <R> CompletableFuture<DataFetcherResult<List<R>>> collect(Publisher<R> publisher, final ExecutionStepInfo step) {
        final CompletableFuture promise = new CompletableFuture();
        this.executor.execute(() -> publisher.subscribe(new Subscriber<R>(){
            private final List buffer = new ArrayList();

            public void onSubscribe(Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            public void onNext(R result) {
                this.buffer.add(result);
            }

            public void onError(Throwable error) {
                ExceptionWhileDataFetching wrapped = new ExceptionWhileDataFetching(step.getPath(), error, step.getField().getSingleField().getSourceLocation());
                promise.complete(DataFetcherResult.newResult().data((Object)this.buffer).error((GraphQLError)wrapped).build());
            }

            public void onComplete() {
                promise.complete(DataFetcherResult.newResult().data((Object)this.buffer).build());
            }
        }));
        return promise;
    }

    private GraphQLOutputType unwrapList(GraphQLOutputType type) {
        if (type instanceof GraphQLNonNull) {
            GraphQLType wrapped = ((GraphQLNonNull)type).getWrappedType();
            if (wrapped instanceof GraphQLList) {
                return (GraphQLOutputType)((GraphQLList)wrapped).getWrappedType();
            }
        } else if (type instanceof GraphQLList) {
            return (GraphQLOutputType)((GraphQLList)type).getWrappedType();
        }
        return type;
    }
}

