/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import graphql.language.OperationDefinition;
import io.leangen.graphql.annotations.Batched;
import io.leangen.graphql.annotations.GraphQLComplexity;
import io.leangen.graphql.generator.JavaDeprecationMappingConfig;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.metadata.execution.FieldAccessor;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.query.AbstractResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.AnnotatedArgumentBuilder;
import io.leangen.graphql.metadata.strategy.query.ArgumentBuilderParams;
import io.leangen.graphql.metadata.strategy.query.DefaultMethodInvokerFactory;
import io.leangen.graphql.metadata.strategy.query.DefaultOperationInfoGenerator;
import io.leangen.graphql.metadata.strategy.query.OperationInfoGeneratorParams;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilderParams;
import io.leangen.graphql.metadata.strategy.value.Property;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.ReservedStrings;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public class PublicResolverBuilder
extends AbstractResolverBuilder {
    private String[] basePackages;
    private JavaDeprecationMappingConfig javaDeprecationConfig;

    public PublicResolverBuilder() {
        this(new String[0]);
    }

    public PublicResolverBuilder(String ... basePackages) {
        this.operationInfoGenerator = new DeprecationAwareOperationInfoGenerator();
        this.argumentBuilder = new AnnotatedArgumentBuilder();
        this.propertyElementReducer = AbstractResolverBuilder::mergePropertyElements;
        this.withBasePackages(basePackages);
        this.withMethodInvokerFactory(new DefaultMethodInvokerFactory());
        this.withJavaDeprecation(new JavaDeprecationMappingConfig(true, "Deprecated"));
        this.withDefaultFilters();
    }

    public PublicResolverBuilder withBasePackages(String ... basePackages) {
        this.basePackages = basePackages;
        return this;
    }

    public PublicResolverBuilder withJavaDeprecationRespected(boolean javaDeprecation) {
        this.javaDeprecationConfig = new JavaDeprecationMappingConfig(javaDeprecation, "Deprecated");
        return this;
    }

    public PublicResolverBuilder withJavaDeprecation(JavaDeprecationMappingConfig javaDeprecationConfig) {
        this.javaDeprecationConfig = javaDeprecationConfig;
        return this;
    }

    @Override
    public Collection<Resolver> buildQueryResolvers(ResolverBuilderParams params) {
        Set<Property> properties = this.findProperties(params);
        Collection<Resolver> propertyAccessors = this.buildPropertyAccessors(properties.stream(), params);
        Collection<Resolver> methodInvokers = this.buildMethodInvokers(params, (method, par) -> this.isQuery((Method)method, (ResolverBuilderParams)par) && properties.stream().noneMatch(prop -> prop.getGetter().equals(method)), OperationDefinition.Operation.QUERY, true);
        Collection<Resolver> fieldAccessors = this.buildFieldAccessors(params);
        return Utils.concat(methodInvokers.stream(), propertyAccessors.stream(), fieldAccessors.stream()).collect(Collectors.toSet());
    }

    protected Set<Property> findProperties(ResolverBuilderParams params) {
        return ClassUtils.getProperties(ClassUtils.getRawType(params.getBeanType().getType()));
    }

    @Override
    public Collection<Resolver> buildMutationResolvers(ResolverBuilderParams params) {
        return this.buildMethodInvokers(params, this::isMutation, OperationDefinition.Operation.MUTATION, false);
    }

    @Override
    public Collection<Resolver> buildSubscriptionResolvers(ResolverBuilderParams params) {
        return this.buildMethodInvokers(params, this::isSubscription, OperationDefinition.Operation.SUBSCRIPTION, false);
    }

    private Collection<Resolver> buildMethodInvokers(ResolverBuilderParams params, BiPredicate<Method, ResolverBuilderParams> filter, OperationDefinition.Operation operation, boolean batchable) {
        MessageBundle messageBundle = params.getEnvironment().messageBundle;
        AnnotatedType beanType = params.getBeanType();
        Supplier<Object> querySourceBean = params.getQuerySourceBeanSupplier();
        Class rawType = ClassUtils.getRawType(beanType.getType());
        if (rawType.isArray() || rawType.isPrimitive()) {
            return Collections.emptyList();
        }
        return Arrays.stream(rawType.getMethods()).filter(method -> filter.test((Method)method, params)).filter(method -> params.getInclusionStrategy().includeOperation(Collections.singletonList(method), beanType)).filter(this.getFilters().stream().reduce(Predicate::and).orElse(ACCEPT_ALL)).map(method -> {
            TypedElement element = new TypedElement(this.getReturnType((Method)method, params), (AnnotatedElement)method);
            OperationInfoGeneratorParams infoParams = new OperationInfoGeneratorParams(element, beanType, querySourceBean, messageBundle, operation);
            return new Resolver(messageBundle.interpolate(this.operationInfoGenerator.name(infoParams)), messageBundle.interpolate(this.operationInfoGenerator.description(infoParams)), messageBundle.interpolate(ReservedStrings.decode(this.operationInfoGenerator.deprecationReason(infoParams))), batchable && method.isAnnotationPresent(Batched.class), this.methodInvokerFactory.create(querySourceBean, (Method)method, beanType, params.getExposedBeanType()), element, this.argumentBuilder.buildResolverArguments(new ArgumentBuilderParams((Method)method, beanType, params.getInclusionStrategy(), params.getTypeTransformer(), params.getEnvironment())), method.isAnnotationPresent(GraphQLComplexity.class) ? method.getAnnotation(GraphQLComplexity.class).value() : null);
        }).collect(Collectors.toList());
    }

    private Collection<Resolver> buildPropertyAccessors(Stream<Property> properties, ResolverBuilderParams params) {
        MessageBundle messageBundle = params.getEnvironment().messageBundle;
        AnnotatedType beanType = params.getBeanType();
        Predicate mergedFilters = this.getFilters().stream().reduce(Predicate::and).orElse(ACCEPT_ALL);
        return properties.filter(prop -> this.isQuery((Property)prop, params)).filter(prop -> mergedFilters.test(prop.getField()) && mergedFilters.test(prop.getGetter())).filter(prop -> params.getInclusionStrategy().includeOperation(Arrays.asList(prop.getField(), prop.getGetter()), beanType)).map(prop -> {
            TypedElement element = (TypedElement)this.propertyElementReducer.apply(new TypedElement(this.getFieldType(prop.getField(), params), prop.getField()), new TypedElement(this.getReturnType(prop.getGetter(), params), prop.getGetter()));
            OperationInfoGeneratorParams infoParams = new OperationInfoGeneratorParams(element, beanType, params.getQuerySourceBeanSupplier(), messageBundle, OperationDefinition.Operation.QUERY);
            return new Resolver(messageBundle.interpolate(this.operationInfoGenerator.name(infoParams)), messageBundle.interpolate(this.operationInfoGenerator.description(infoParams)), messageBundle.interpolate(ReservedStrings.decode(this.operationInfoGenerator.deprecationReason(infoParams))), element.isAnnotationPresent(Batched.class), this.methodInvokerFactory.create(params.getQuerySourceBeanSupplier(), prop.getGetter(), beanType, params.getExposedBeanType()), element, this.argumentBuilder.buildResolverArguments(new ArgumentBuilderParams(prop.getGetter(), beanType, params.getInclusionStrategy(), params.getTypeTransformer(), params.getEnvironment())), element.isAnnotationPresent(GraphQLComplexity.class) ? element.getAnnotation(GraphQLComplexity.class).value() : null);
        }).collect(Collectors.toSet());
    }

    private Collection<Resolver> buildFieldAccessors(ResolverBuilderParams params) {
        MessageBundle messageBundle = params.getEnvironment().messageBundle;
        AnnotatedType beanType = params.getBeanType();
        return Arrays.stream(ClassUtils.getRawType(beanType.getType()).getFields()).filter(field -> this.isQuery((Field)field, params)).filter(this.getFilters().stream().reduce(Predicate::and).orElse(ACCEPT_ALL)).filter(field -> params.getInclusionStrategy().includeOperation(Collections.singletonList(field), beanType)).map(field -> {
            TypedElement element = new TypedElement(this.getFieldType((Field)field, params), (AnnotatedElement)field);
            OperationInfoGeneratorParams infoParams = new OperationInfoGeneratorParams(element, beanType, params.getQuerySourceBeanSupplier(), messageBundle, OperationDefinition.Operation.QUERY);
            return new Resolver(messageBundle.interpolate(this.operationInfoGenerator.name(infoParams)), messageBundle.interpolate(this.operationInfoGenerator.description(infoParams)), messageBundle.interpolate(ReservedStrings.decode(this.operationInfoGenerator.deprecationReason(infoParams))), false, new FieldAccessor((Field)field, beanType), element, Collections.emptyList(), field.isAnnotationPresent(GraphQLComplexity.class) ? field.getAnnotation(GraphQLComplexity.class).value() : null);
        }).collect(Collectors.toSet());
    }

    protected boolean isQuery(Method method, ResolverBuilderParams params) {
        return this.isPackageAcceptable(method, params) && !this.isMutation(method, params) && !this.isSubscription(method, params);
    }

    protected boolean isQuery(Field field, ResolverBuilderParams params) {
        return this.isPackageAcceptable(field, params);
    }

    protected boolean isQuery(Property property, ResolverBuilderParams params) {
        return this.isQuery(property.getGetter(), params);
    }

    protected boolean isMutation(Method method, ResolverBuilderParams params) {
        return this.isPackageAcceptable(method, params) && method.getReturnType() == Void.TYPE;
    }

    protected boolean isSubscription(Method method, ResolverBuilderParams params) {
        return this.isPackageAcceptable(method, params) && Publisher.class.isAssignableFrom(method.getReturnType());
    }

    protected boolean isPackageAcceptable(Member method, ResolverBuilderParams params) {
        Class beanType = ClassUtils.getRawType(params.getBeanType().getType());
        String[] defaultPackages = params.getBasePackages();
        String[] basePackages = new String[]{};
        if (Utils.isNotEmpty(this.basePackages)) {
            basePackages = this.basePackages;
        } else if (Utils.isNotEmpty(defaultPackages)) {
            basePackages = defaultPackages;
        } else if (beanType.getPackage() != null) {
            basePackages = new String[]{beanType.getPackage().getName()};
        }
        basePackages = (String[])Arrays.stream(basePackages).filter(Utils::isNotEmpty).toArray(String[]::new);
        return method.getDeclaringClass().equals(beanType) || Arrays.stream(basePackages).anyMatch(basePackage -> ClassUtils.isSubPackage(method.getDeclaringClass().getPackage(), basePackage));
    }

    private class DeprecationAwareOperationInfoGenerator
    extends DefaultOperationInfoGenerator {
        private DeprecationAwareOperationInfoGenerator() {
        }

        @Override
        public String deprecationReason(OperationInfoGeneratorParams params) {
            String explicit = ReservedStrings.decode(super.deprecationReason(params));
            if (explicit == null && ((PublicResolverBuilder)PublicResolverBuilder.this).javaDeprecationConfig.enabled && params.getElement().isAnnotationPresent(Deprecated.class)) {
                return ((PublicResolverBuilder)PublicResolverBuilder.this).javaDeprecationConfig.deprecationReason;
            }
            return explicit;
        }
    }
}

