/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import io.leangen.graphql.annotations.GraphQLEnumValue;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.value.InputFieldInfoGenerator;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private final MessageBundle messageBundle;
    private Map<Type, List<NamedType>> typeMap;
    private final InputFieldInfoGenerator inputInfoGen = new InputFieldInfoGenerator();
    private static TypeResolverBuilder<?> typeResolverBuilder;
    private static final Logger log;

    AnnotationIntrospector(Map<Type, List<NamedType>> typeMap, MessageBundle messageBundle) {
        this.typeMap = typeMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(typeMap);
        this.messageBundle = messageBundle;
    }

    public PropertyName findNameForDeserialization(Annotated annotated) {
        return this.inputInfoGen.getName(this.getAnnotatedCandidates(annotated), this.messageBundle).map(PropertyName::new).orElse(super.findNameForDeserialization(annotated));
    }

    public PropertyName findNameForSerialization(Annotated annotated) {
        return this.inputInfoGen.getName(this.getAnnotatedCandidates(annotated), this.messageBundle).map(PropertyName::new).orElse(super.findNameForSerialization(annotated));
    }

    public String findPropertyDescription(Annotated annotated) {
        return this.inputInfoGen.getDescription(this.getAnnotatedCandidates(annotated), this.messageBundle).orElse(super.findPropertyDescription(annotated));
    }

    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        TypeResolverBuilder original = super.findTypeResolver(config, ac, baseType);
        if (original != null) {
            return original;
        }
        if (this.typeMap.containsKey(ac.getRawType()) || this.typeMap.isEmpty() && Utils.isNotEmpty(super.findSubtypes((Annotated)ac))) {
            return typeResolverBuilder;
        }
        return null;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        List original = super.findSubtypes(a);
        if ((original == null || original.isEmpty()) && this.typeMap.containsKey(a.getRawType())) {
            return this.typeMap.get(a.getRawType());
        }
        return null;
    }

    public String[] findEnumValues(Class<?> enumType, Enum<?>[] enumValues, String[] defaultNames) {
        String[] jacksonNames = super.findEnumValues(enumType, (Enum[])enumValues, defaultNames);
        for (int i = 0; i < enumValues.length; ++i) {
            GraphQLEnumValue annotation = ClassUtils.getEnumConstantField(enumValues[i]).getAnnotation(GraphQLEnumValue.class);
            if (annotation == null || !Utils.isNotEmpty(annotation.name())) continue;
            jacksonNames[i] = this.messageBundle.interpolate(annotation.name());
        }
        return jacksonNames;
    }

    private List<AnnotatedElement> getAnnotatedCandidates(Annotated annotated) {
        ArrayList<AnnotatedElement> propertyElements = new ArrayList<AnnotatedElement>(3);
        if (annotated instanceof AnnotatedParameter) {
            AnnotatedParameter parameter = (AnnotatedParameter)annotated;
            Executable owner = (Executable)parameter.getOwner().getAnnotated();
            propertyElements.add(owner.getParameters()[parameter.getIndex()]);
        } else if (annotated instanceof AnnotatedField) {
            AnnotatedField field = (AnnotatedField)annotated;
            try {
                Arrays.stream(Introspector.getBeanInfo(field.getDeclaringClass()).getPropertyDescriptors()).filter(prop -> field.getName().equals(prop.getName())).findFirst().ifPresent(prop -> this.addPropertyMethods((List<AnnotatedElement>)propertyElements, (PropertyDescriptor)prop));
            }
            catch (IntrospectionException e) {
                log.warn("Introspection of {} failed. GraphQL input fields might be incorrectly mapped.", (Object)field.getDeclaringClass());
            }
            propertyElements.add(annotated.getAnnotated());
        } else if (annotated instanceof AnnotatedMethod) {
            Method setter = (Method)annotated.getAnnotated();
            try {
                Arrays.stream(Introspector.getBeanInfo(setter.getDeclaringClass()).getPropertyDescriptors()).filter(prop -> setter.equals(prop.getWriteMethod())).findFirst().ifPresent(prop -> this.addPropertyMethods((List<AnnotatedElement>)propertyElements, (PropertyDescriptor)prop));
            }
            catch (IntrospectionException e) {
                log.warn("Introspection of {} failed. GraphQL input fields might be incorrectly mapped.", setter.getDeclaringClass());
            }
            if (propertyElements.isEmpty()) {
                propertyElements.add(setter);
            }
        }
        return propertyElements;
    }

    private void addPropertyMethods(List<AnnotatedElement> propertyElements, PropertyDescriptor prop) {
        if (prop.getWriteMethod() != null) {
            propertyElements.add(prop.getWriteMethod());
        }
        if (prop.getReadMethod() != null) {
            propertyElements.add(prop.getReadMethod());
        }
    }

    static {
        log = LoggerFactory.getLogger(AnnotationIntrospector.class);
        typeResolverBuilder = new StdTypeResolverBuilder().init(JsonTypeInfo.Id.NAME, null).inclusion(JsonTypeInfo.As.PROPERTY).typeProperty("_type_");
    }
}

