/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.jackson;

import com.fasterxml.jackson.databind.JavaType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;

public class TypeUtils {
    static AnnotatedType toJavaType(JavaType jacksonType) {
        if (jacksonType.getRawClass().getTypeParameters().length > 0) {
            AnnotatedType[] paramTypes = (AnnotatedType[])jacksonType.getBindings().getTypeParameters().stream().map(TypeUtils::toJavaType).toArray(AnnotatedType[]::new);
            return TypeFactory.parameterizedAnnotatedClass((Class)jacksonType.getRawClass(), (Annotation[])jacksonType.getRawClass().getAnnotations(), (AnnotatedType[])paramTypes);
        }
        if (jacksonType.isArrayType()) {
            return TypeFactory.arrayOf((AnnotatedType)TypeUtils.toJavaType(jacksonType.getContentType()), (Annotation[])new Annotation[0]);
        }
        return GenericTypeReflector.annotate((Type)jacksonType.getRawClass());
    }
}

