/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import io.leangen.graphql.execution.ContextWrapper;
import io.leangen.graphql.execution.complexity.ComplexityAnalysisInstrumentation;
import io.leangen.graphql.execution.complexity.JavaScriptEvaluator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class GraphQLRuntime
extends GraphQL {
    private final GraphQL delegate;

    private GraphQLRuntime(GraphQL delegate, GraphQLSchema schema) {
        super(schema);
        this.delegate = delegate;
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput executionInput) {
        return this.delegate.executeAsync(executionInput.transform(builder -> builder.context((Object)new ContextWrapper(executionInput.getContext()))));
    }

    public static Builder newGraphQL(GraphQLSchema graphQLSchema) {
        return new Builder(graphQLSchema);
    }

    public static class Builder
    extends GraphQL.Builder {
        private GraphQLSchema graphQLSchema;
        private List<Instrumentation> instrumentations;

        private Builder(GraphQLSchema graphQLSchema) {
            super(graphQLSchema);
            this.graphQLSchema = graphQLSchema;
            this.instrumentations = new ArrayList<Instrumentation>();
        }

        public Builder instrumentation(Instrumentation instrumentation) {
            this.instrumentations.add(instrumentation);
            return this;
        }

        public Builder maximumQueryComplexity(int limit) {
            this.instrumentations.add((Instrumentation)new ComplexityAnalysisInstrumentation(new JavaScriptEvaluator(), limit));
            return this;
        }

        public GraphQLRuntime build() {
            if (this.instrumentations.size() == 1) {
                super.instrumentation(this.instrumentations.get(0));
            } else if (!this.instrumentations.isEmpty()) {
                super.instrumentation((Instrumentation)new ChainedInstrumentation(this.instrumentations));
            }
            return new GraphQLRuntime(super.build(), this.graphQLSchema);
        }
    }
}

