/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StreamToCollectionTypeAdapter<T>
extends AbstractTypeAdapter<Stream<T>, List<T>> {
    @Override
    public List<T> convertOutput(Stream<T> original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        try (Stream<Object> stream = original;){
            List list = stream.map(item -> resolutionEnvironment.convertOutput(item, this.getElementType(type))).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public Stream<T> convertInput(List<T> substitute, AnnotatedType type, GlobalEnvironment environment, ValueMapper valueMapper) {
        return substitute.stream().map(item -> environment.convertInput(item, this.getElementType(type), valueMapper));
    }

    @Override
    public AnnotatedType getSubstituteType(AnnotatedType original) {
        return TypeFactory.parameterizedAnnotatedClass(List.class, (Annotation[])original.getAnnotations(), (AnnotatedType[])new AnnotatedType[]{this.getElementType(original)});
    }

    private AnnotatedType getElementType(AnnotatedType type) {
        return GenericTypeReflector.getTypeParameter((AnnotatedType)type, Stream.class.getTypeParameters()[0]);
    }
}

