/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.gson;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.generator.mapping.InputConverter;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.metadata.strategy.value.gson.GsonValueMapper;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;

class ConvertingDeserializer
implements JsonDeserializer {
    private final InputConverter inputConverter;
    private final GlobalEnvironment environment;
    private final ValueMapper valueMapper;

    ConvertingDeserializer(InputConverter inputConverter, GlobalEnvironment environment, Gson gson) {
        this.inputConverter = inputConverter;
        this.environment = environment;
        this.valueMapper = new GsonValueMapper(gson);
    }

    public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext deserializationContext) throws JsonParseException {
        AnnotatedType detectedType = GenericTypeReflector.annotate((Type)type);
        Type substituteType = this.environment.getMappableInputType(detectedType).getType();
        Object substitute = deserializationContext.deserialize(jsonElement, substituteType);
        return this.inputConverter.convertInput(substitute, detectedType, this.environment, this.valueMapper);
    }
}

