/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.jackson;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.type.DefaultTypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.ScalarDeserializationStrategy;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.jackson.AnnotationIntrospector;
import io.leangen.graphql.metadata.strategy.value.jackson.ConvertingDeserializers;
import io.leangen.graphql.metadata.strategy.value.jackson.JacksonValueMapper;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JacksonValueMapperFactory
implements ValueMapperFactory,
ScalarDeserializationStrategy {
    private final ObjectMapper prototype;
    private final List<Configurer> configurers;
    private final TypeInfoGenerator typeInfoGenerator;
    private static final Configurer IMPLICIT_MODULES = new ImplicitModuleConfigurer();

    public JacksonValueMapperFactory() {
        this(null, new DefaultTypeInfoGenerator(), JacksonValueMapperFactory.defaultConfigurers());
    }

    private JacksonValueMapperFactory(ObjectMapper prototype, TypeInfoGenerator typeInfoGenerator, List<Configurer> configurers) {
        this.prototype = prototype;
        this.configurers = Objects.requireNonNull(configurers);
        this.typeInfoGenerator = Objects.requireNonNull(typeInfoGenerator);
    }

    @Override
    public JacksonValueMapper getValueMapper(Map<Class, List<Class<?>>> concreteSubTypes, GlobalEnvironment environment) {
        return new JacksonValueMapper(this.initBuilder(concreteSubTypes, environment));
    }

    private ObjectMapper initBuilder(Map<Class, List<Class<?>>> concreteSubTypes, GlobalEnvironment environment) {
        ObjectMapper objectMapper = this.prototype != null ? this.prototype.copy() : new ObjectMapper();
        return this.configurers.stream().reduce(objectMapper, (mapper, configurer) -> configurer.configure(new ConfigurerParams((ObjectMapper)mapper, concreteSubTypes, this.typeInfoGenerator, environment)), (b1, b2) -> b2);
    }

    @Override
    public boolean isDirectlyDeserializable(AnnotatedType type) {
        return GenericTypeReflector.isSuperType(TreeNode.class, (Type)type.getType());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static ArrayList<Configurer> defaultConfigurers() {
        return new ArrayList<Configurer>(Arrays.asList(IMPLICIT_MODULES, new AbstractClassAdapterConfigurer()));
    }

    static /* synthetic */ ArrayList access$000() {
        return JacksonValueMapperFactory.defaultConfigurers();
    }

    public static class Builder {
        private List<Configurer> configurers = JacksonValueMapperFactory.access$000();
        private TypeInfoGenerator typeInfoGenerator = new DefaultTypeInfoGenerator();
        private ObjectMapper prototype;

        public Builder withConfigurers(Configurer ... configurer) {
            Collections.addAll(this.configurers, configurer);
            return this;
        }

        public Builder withTypeInfoGenerator(TypeInfoGenerator typeInfoGenerator) {
            this.typeInfoGenerator = typeInfoGenerator;
            return this;
        }

        public Builder withPrototype(ObjectMapper prototype) {
            this.prototype = prototype;
            return this;
        }

        public Builder withExplicitModulesOnly() {
            this.configurers.remove(IMPLICIT_MODULES);
            return this;
        }

        public JacksonValueMapperFactory build() {
            return new JacksonValueMapperFactory(this.prototype, this.typeInfoGenerator, this.configurers);
        }
    }

    public static class ConfigurerParams {
        final ObjectMapper objectMapper;
        final Map<Class, List<Class<?>>> concreteSubTypes;
        final TypeInfoGenerator metaDataGen;
        final GlobalEnvironment environment;

        ConfigurerParams(ObjectMapper objectMapper, Map<Class, List<Class<?>>> concreteSubTypes, TypeInfoGenerator metaDataGen, GlobalEnvironment environment) {
            this.objectMapper = objectMapper;
            this.concreteSubTypes = concreteSubTypes;
            this.metaDataGen = metaDataGen;
            this.environment = environment;
        }

        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        public Map<Class, List<Class<?>>> getConcreteSubTypes() {
            return this.concreteSubTypes;
        }

        public TypeInfoGenerator getMetaDataGen() {
            return this.metaDataGen;
        }

        public GlobalEnvironment getEnvironment() {
            return this.environment;
        }
    }

    @FunctionalInterface
    public static interface Configurer {
        public ObjectMapper configure(ConfigurerParams var1);
    }

    public static class AbstractClassAdapterConfigurer
    implements Configurer {
        @Override
        public ObjectMapper configure(ConfigurerParams params) {
            ObjectMapper mapper = params.objectMapper.registerModule(this.getAnnotationIntrospectorModule(this.unambiguousSubtypes(params.concreteSubTypes), this.ambiguousSubtypes(params.concreteSubTypes, params.metaDataGen, params.environment.messageBundle), params.environment.messageBundle));
            if (!params.environment.getInputConverters().isEmpty()) {
                mapper.registerModule(this.getDeserializersModule(params.environment));
            }
            return mapper;
        }

        private Map<Class, Class> unambiguousSubtypes(Map<Class, List<Class<?>>> concreteSubTypes) {
            return concreteSubTypes.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() == 1).collect(Collectors.toMap(Map.Entry::getKey, e -> (Class)((List)e.getValue()).get(0)));
        }

        private Map<Type, List<NamedType>> ambiguousSubtypes(Map<Class, List<Class<?>>> concreteSubTypes, TypeInfoGenerator metaDataGen, MessageBundle messageBundle) {
            HashMap<Type, List<NamedType>> types = new HashMap<Type, List<NamedType>>();
            concreteSubTypes.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
                List subTypes = ((List)entry.getValue()).stream().map(sub -> new NamedType(sub, metaDataGen.generateTypeName(GenericTypeReflector.annotate((Type)sub), messageBundle))).collect(Collectors.toList());
                if (!subTypes.isEmpty()) {
                    types.put((Type)entry.getKey(), subTypes);
                }
            });
            return types;
        }

        private Module getDeserializersModule(final GlobalEnvironment environment) {
            return new Module(){

                public String getModuleName() {
                    return "graphql-spqr-deserializers";
                }

                public Version version() {
                    return Version.unknownVersion();
                }

                public void setupModule(Module.SetupContext setupContext) {
                    setupContext.addDeserializers((Deserializers)new ConvertingDeserializers(environment));
                }
            };
        }

        private Module getAnnotationIntrospectorModule(Map<Class, Class> unambiguousTypes, final Map<Type, List<NamedType>> ambiguousTypes, final MessageBundle messageBundle) {
            SimpleModule module = new SimpleModule("graphql-spqr-annotation-introspector"){

                public void setupModule(Module.SetupContext context) {
                    super.setupModule(context);
                    context.insertAnnotationIntrospector((com.fasterxml.jackson.databind.AnnotationIntrospector)new AnnotationIntrospector(ambiguousTypes, messageBundle));
                }
            };
            unambiguousTypes.forEach((arg_0, arg_1) -> ((SimpleModule)module).addAbstractTypeMapping(arg_0, arg_1));
            return module;
        }
    }

    public static class ImplicitModuleConfigurer
    implements Configurer {
        @Override
        public ObjectMapper configure(ConfigurerParams params) {
            return params.objectMapper.findAndRegisterModules();
        }
    }
}

