/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisException;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.masterreplica.ReadOnlyCommands;
import io.lettuce.core.masterreplica.UpstreamReplicaConnectionProvider;
import io.lettuce.core.protocol.ConnectionFacade;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.resource.ClientResources;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

class UpstreamReplicaChannelWriter
implements RedisChannelWriter {
    private UpstreamReplicaConnectionProvider<?, ?> upstreamReplicaConnectionProvider;
    private final ClientResources clientResources;
    private boolean closed = false;
    private boolean inTransaction;

    UpstreamReplicaChannelWriter(UpstreamReplicaConnectionProvider<?, ?> upstreamReplicaConnectionProvider, ClientResources clientResources) {
        this.upstreamReplicaConnectionProvider = upstreamReplicaConnectionProvider;
        this.clientResources = clientResources;
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        LettuceAssert.notNull(command, "Command must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        if (UpstreamReplicaChannelWriter.isStartTransaction(command.getType())) {
            this.inTransaction = true;
        }
        UpstreamReplicaConnectionProvider.Intent intent = this.inTransaction ? UpstreamReplicaConnectionProvider.Intent.WRITE : UpstreamReplicaChannelWriter.getIntent(command.getType());
        CompletableFuture<StatefulRedisConnection<?, ?>> future = this.upstreamReplicaConnectionProvider.getConnectionAsync(intent);
        if (this.isEndTransaction(command.getType())) {
            this.inTransaction = false;
        }
        if (UpstreamReplicaChannelWriter.isSuccessfullyCompleted(future)) {
            UpstreamReplicaChannelWriter.writeCommand(command, future.join(), null);
        } else {
            future.whenComplete((c, t) -> UpstreamReplicaChannelWriter.writeCommand(command, c, t));
        }
        return command;
    }

    private static <K, V> void writeCommand(RedisCommand<K, V, ?> command, StatefulRedisConnection<K, V> connection, Throwable throwable) {
        if (throwable != null) {
            command.completeExceptionally(throwable);
            return;
        }
        try {
            connection.dispatch(command);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> commands) {
        LettuceAssert.notNull(commands, "Commands must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        for (RedisCommand<K, V, ?> command : commands) {
            if (!UpstreamReplicaChannelWriter.isStartTransaction(command.getType())) continue;
            this.inTransaction = true;
            break;
        }
        UpstreamReplicaConnectionProvider.Intent intent = this.inTransaction ? UpstreamReplicaConnectionProvider.Intent.WRITE : UpstreamReplicaChannelWriter.getIntent(commands);
        CompletableFuture<StatefulRedisConnection<?, ?>> future = this.upstreamReplicaConnectionProvider.getConnectionAsync(intent);
        for (RedisCommand<K, V, ?> command : commands) {
            if (!this.isEndTransaction(command.getType())) continue;
            this.inTransaction = false;
            break;
        }
        if (UpstreamReplicaChannelWriter.isSuccessfullyCompleted(future)) {
            UpstreamReplicaChannelWriter.writeCommands(commands, future.join(), null);
        } else {
            future.whenComplete((c, t) -> UpstreamReplicaChannelWriter.writeCommands(commands, c, t));
        }
        return commands;
    }

    private static <K, V> void writeCommands(Collection<? extends RedisCommand<K, V, ?>> commands, StatefulRedisConnection<K, V> connection, Throwable throwable) {
        if (throwable != null) {
            commands.forEach(c -> c.completeExceptionally(throwable));
            return;
        }
        try {
            connection.dispatch(commands);
        }
        catch (Exception e) {
            commands.forEach(c -> c.completeExceptionally(e));
        }
    }

    static UpstreamReplicaConnectionProvider.Intent getIntent(Collection<? extends RedisCommand<?, ?, ?>> commands) {
        boolean w = false;
        boolean r = false;
        UpstreamReplicaConnectionProvider.Intent singleIntent = UpstreamReplicaConnectionProvider.Intent.WRITE;
        for (RedisCommand<?, ?, ?> command : commands) {
            singleIntent = UpstreamReplicaChannelWriter.getIntent(command.getType());
            if (singleIntent == UpstreamReplicaConnectionProvider.Intent.READ) {
                r = true;
            }
            if (singleIntent == UpstreamReplicaConnectionProvider.Intent.WRITE) {
                w = true;
            }
            if (!r || !w) continue;
            return UpstreamReplicaConnectionProvider.Intent.WRITE;
        }
        return singleIntent;
    }

    private static UpstreamReplicaConnectionProvider.Intent getIntent(ProtocolKeyword type) {
        return ReadOnlyCommands.isReadOnlyCommand(type) ? UpstreamReplicaConnectionProvider.Intent.READ : UpstreamReplicaConnectionProvider.Intent.WRITE;
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.closed) {
            return CompletableFuture.completedFuture(null);
        }
        this.closed = true;
        CompletableFuture<Void> future = null;
        if (this.upstreamReplicaConnectionProvider != null) {
            future = this.upstreamReplicaConnectionProvider.closeAsync();
            this.upstreamReplicaConnectionProvider = null;
        }
        if (future == null) {
            future = CompletableFuture.completedFuture(null);
        }
        return future;
    }

    UpstreamReplicaConnectionProvider<?, ?> getUpstreamReplicaConnectionProvider() {
        return this.upstreamReplicaConnectionProvider;
    }

    @Override
    public void setConnectionFacade(ConnectionFacade connection) {
    }

    @Override
    public ClientResources getClientResources() {
        return this.clientResources;
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.upstreamReplicaConnectionProvider.setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.upstreamReplicaConnectionProvider.flushCommands();
    }

    @Override
    public void reset() {
        this.upstreamReplicaConnectionProvider.reset();
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.upstreamReplicaConnectionProvider.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.upstreamReplicaConnectionProvider.getReadFrom();
    }

    private static boolean isSuccessfullyCompleted(CompletableFuture<?> connectFuture) {
        return connectFuture.isDone() && !connectFuture.isCompletedExceptionally();
    }

    private static boolean isStartTransaction(ProtocolKeyword command) {
        return command.name().equals("MULTI");
    }

    private boolean isEndTransaction(ProtocolKeyword command) {
        return command.name().equals("EXEC") || command.name().equals("DISCARD");
    }
}

