/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.EventLoopResources;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class EpollProvider {
    private static final InternalLogger logger;
    private static final String EPOLL_ENABLED_KEY = "io.lettuce.core.epoll";
    private static final boolean EPOLL_ENABLED;
    private static final boolean EPOLL_AVAILABLE;
    private static final EventLoopResources EPOLL_RESOURCES;

    public static boolean isAvailable() {
        return EPOLL_AVAILABLE && EPOLL_ENABLED;
    }

    static void checkForEpollLibrary() {
        LettuceAssert.assertState(EPOLL_ENABLED, String.format("epoll use is disabled via System properties (%s)", EPOLL_ENABLED_KEY));
        LettuceAssert.assertState(EpollProvider.isAvailable(), "netty-transport-native-epoll is not available. Make sure netty-transport-native-epoll library on the class path and supported by your operating system.");
    }

    public static EventLoopResources getResources() {
        return EPOLL_RESOURCES;
    }

    static {
        boolean availability;
        logger = InternalLoggerFactory.getInstance(EpollProvider.class);
        EPOLL_ENABLED = Boolean.parseBoolean(SystemPropertyUtil.get((String)EPOLL_ENABLED_KEY, (String)"true"));
        try {
            Class.forName("io.netty.channel.epoll.Epoll");
            availability = Epoll.isAvailable();
        }
        catch (ClassNotFoundException e) {
            availability = false;
        }
        EPOLL_AVAILABLE = availability;
        if (EPOLL_AVAILABLE) {
            logger.debug("Starting with epoll library");
            EPOLL_RESOURCES = AvailableEpollResources.INSTANCE;
        } else {
            logger.debug("Starting without optional epoll library");
            EPOLL_RESOURCES = UnavailableEpollResources.INSTANCE;
        }
    }

    static enum AvailableEpollResources implements EventLoopResources
    {
        INSTANCE;


        @Override
        public boolean matches(Class<? extends EventExecutorGroup> type) {
            LettuceAssert.notNull(type, "EventLoopGroup type must not be null");
            return type.equals(EpollEventLoopGroup.class);
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            EpollProvider.checkForEpollLibrary();
            return new EpollEventLoopGroup(nThreads, threadFactory);
        }

        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            EpollProvider.checkForEpollLibrary();
            return EpollDomainSocketChannel.class;
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            EpollProvider.checkForEpollLibrary();
            return EpollSocketChannel.class;
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            EpollProvider.checkForEpollLibrary();
            return EpollEventLoopGroup.class;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            EpollProvider.checkForEpollLibrary();
            return new DomainSocketAddress(socketPath);
        }
    }

    static enum UnavailableEpollResources implements EventLoopResources
    {
        INSTANCE;


        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            EpollProvider.checkForEpollLibrary();
            return null;
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            EpollProvider.checkForEpollLibrary();
            return null;
        }

        @Override
        public boolean matches(Class<? extends EventExecutorGroup> type) {
            EpollProvider.checkForEpollLibrary();
            return false;
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            EpollProvider.checkForEpollLibrary();
            return null;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            EpollProvider.checkForEpollLibrary();
            return null;
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            EpollProvider.checkForEpollLibrary();
            return null;
        }
    }
}

