/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.EpollProvider;
import io.lettuce.core.resource.EventLoopResources;
import io.lettuce.core.resource.IOUringProvider;
import io.lettuce.core.resource.KqueueProvider;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Transports {
    public static Class<? extends EventLoopGroup> eventLoopGroupClass() {
        if (NativeTransports.isAvailable()) {
            return NativeTransports.eventLoopGroupClass();
        }
        return NioEventLoopGroup.class;
    }

    public static Class<? extends Channel> socketChannelClass() {
        if (NativeTransports.isAvailable()) {
            return NativeTransports.socketChannelClass();
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends DatagramChannel> datagramChannelClass() {
        if (NativeTransports.isAvailable()) {
            return NativeTransports.datagramChannelClass();
        }
        return NioDatagramChannel.class;
    }

    public static class NativeTransports {
        private static final InternalLogger transportsLogger = InternalLoggerFactory.getInstance(Transports.class);
        static EventLoopResources RESOURCES = KqueueProvider.isAvailable() ? KqueueProvider.getResources() : (IOUringProvider.isAvailable() ? IOUringProvider.getResources() : EpollProvider.getResources());

        static boolean isAvailable() {
            if (EpollProvider.isAvailable() && IOUringProvider.isAvailable()) {
                transportsLogger.warn("Both epoll and io_uring native transports are available, epoll has been prioritized.");
            }
            return EpollProvider.isAvailable() || KqueueProvider.isAvailable() || IOUringProvider.isAvailable();
        }

        public static boolean isDomainSocketSupported() {
            return EpollProvider.isAvailable() || KqueueProvider.isAvailable();
        }

        static Class<? extends Channel> socketChannelClass() {
            return RESOURCES.socketChannelClass();
        }

        static Class<? extends DatagramChannel> datagramChannelClass() {
            return RESOURCES.datagramChannelClass();
        }

        public static Class<? extends Channel> domainSocketChannelClass() {
            NativeTransports.assertDomainSocketAvailable();
            return EpollProvider.isAvailable() && IOUringProvider.isAvailable() ? EpollProvider.getResources().domainSocketChannelClass() : RESOURCES.domainSocketChannelClass();
        }

        public static Class<? extends EventLoopGroup> eventLoopGroupClass() {
            return NativeTransports.eventLoopGroupClass(false);
        }

        public static Class<? extends EventLoopGroup> eventLoopGroupClass(boolean domainSocket) {
            return domainSocket && EpollProvider.isAvailable() && IOUringProvider.isAvailable() ? EpollProvider.getResources().eventLoopGroupClass() : RESOURCES.eventLoopGroupClass();
        }

        public static void assertDomainSocketAvailable() {
            LettuceAssert.assertState(NativeTransports.isDomainSocketSupported(), "A unix domain socket connection requires epoll or kqueue and neither is available");
        }
    }
}

