/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.vector.VSimScoreAttribs;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class VSimScoreAttribsMapOutput<K, V>
extends CommandOutput<K, V, Map<V, VSimScoreAttribs>> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(VSimScoreAttribsMapOutput.class);
    private boolean outputError = false;
    private boolean skipCurrentEntry = false;
    private State state = State.KEY;
    private V pendingKey;
    private Double pendingScore;
    private String pendingAttribs;

    public VSimScoreAttribsMapOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void multi(int count) {
        if (this.output == null) {
            this.output = new LinkedHashMap(Math.max(1, count / 2), 1.0f);
        }
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.outputError) {
            return;
        }
        switch (this.state) {
            case KEY: {
                this.pendingKey = bytes == null ? null : this.codec.decodeValue(bytes);
                this.state = State.SCORE;
                return;
            }
            case SCORE: {
                try {
                    this.pendingScore = bytes == null ? null : Double.valueOf(Double.parseDouble(this.decodeString(bytes)));
                    this.state = State.ATTRIBS;
                }
                catch (NumberFormatException e) {
                    LOG.warn("Expected double as string for score, skipping this entry");
                    this.skipCurrentEntry = true;
                    this.pendingScore = null;
                    this.state = State.ATTRIBS;
                }
                return;
            }
            case ATTRIBS: {
                String string = this.pendingAttribs = bytes == null ? null : this.decodeString(bytes);
                if (this.skipCurrentEntry) {
                    this.resetEntryState();
                } else {
                    this.putAndReset();
                }
                return;
            }
        }
    }

    @Override
    public void set(double number) {
        if (this.outputError) {
            return;
        }
        if (this.state == State.SCORE) {
            this.pendingScore = number;
            this.state = State.ATTRIBS;
        } else if (this.state == State.ATTRIBS) {
            LOG.warn("Expected attributes as bulk string but got double; skipping current entry");
            this.resetEntryState();
        } else {
            LOG.warn("Expected key but got double, discarding the result");
            this.output = new HashMap(0);
            this.outputError = true;
        }
    }

    @Override
    public void complete(int depth) {
    }

    private void putAndReset() {
        if (this.output == null) {
            this.output = new LinkedHashMap(1);
        }
        ((Map)this.output).put(this.pendingKey, new VSimScoreAttribs(this.pendingScore != null ? this.pendingScore : Double.NaN, this.pendingAttribs));
        this.resetEntryState();
    }

    private void resetEntryState() {
        this.pendingKey = null;
        this.pendingScore = null;
        this.pendingAttribs = null;
        this.skipCurrentEntry = false;
        this.state = State.KEY;
    }

    private static enum State {
        KEY,
        SCORE,
        ATTRIBS;

    }
}

