/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;

@Experimental
public final class CompareCondition<V> {
    private final Condition condition;
    private final V value;
    private final String digest;

    private CompareCondition(Condition condition, V value, String digestHex) {
        this.condition = condition;
        this.value = value;
        this.digest = digestHex;
    }

    public <K> void build(CommandArgs<K, V> args) {
        args.add(this.condition.getKeyword());
        if (this.condition.equals((Object)Condition.DIGEST_EQUAL) || this.condition.equals((Object)Condition.DIGEST_NOT_EQUAL)) {
            args.add(this.digest);
        } else if (this.condition.equals((Object)Condition.VALUE_EQUAL) || this.condition.equals((Object)Condition.VALUE_NOT_EQUAL)) {
            args.addValue(this.value);
        }
    }

    public static <V> CompareCondition<V> valueEq(V value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return new CompareCondition<V>(Condition.VALUE_EQUAL, value, null);
    }

    public static <V> CompareCondition<V> valueNe(V value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return new CompareCondition<V>(Condition.VALUE_NOT_EQUAL, value, null);
    }

    public static <V> CompareCondition<V> digestEq(String hex16Digest) {
        if (hex16Digest == null) {
            throw new IllegalArgumentException("digest must not be null");
        }
        return new CompareCondition<Object>(Condition.DIGEST_EQUAL, null, hex16Digest);
    }

    public static <V> CompareCondition<V> digestNe(String hex16Digest) {
        if (hex16Digest == null) {
            throw new IllegalArgumentException("digest must not be null");
        }
        return new CompareCondition<Object>(Condition.DIGEST_NOT_EQUAL, null, hex16Digest);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public V getValue() {
        return this.value;
    }

    public String getDigest() {
        return this.digest;
    }

    public String toString() {
        return "ValueCondition{kind=" + (Object)((Object)this.condition) + (this.value != null ? ", value=" + this.value : "") + (this.digest != null ? ", digestHex='" + this.digest + '\'' : "") + '}';
    }

    public static enum Condition {
        VALUE_EQUAL(CommandKeyword.IFEQ),
        VALUE_NOT_EQUAL(CommandKeyword.IFNE),
        DIGEST_EQUAL(CommandKeyword.IFDEQ),
        DIGEST_NOT_EQUAL(CommandKeyword.IFDNE);

        private final CommandKeyword keyword;

        private Condition(CommandKeyword keyword) {
            this.keyword = keyword;
        }

        public CommandKeyword getKeyword() {
            return this.keyword;
        }
    }
}

