/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.LettuceVersion;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceSets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class DriverInfo
implements Serializable {
    private static final String DRIVER_NAME_PATTERN = "^[a-z][a-z0-9_-]*$";
    private static final Set<Character> BRACES = LettuceSets.unmodifiableSet(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'));
    private final String name;
    private final List<String> upstreamDrivers;

    private DriverInfo(String name, List<String> upstreamDrivers) {
        this.name = name;
        this.upstreamDrivers = Collections.unmodifiableList(upstreamDrivers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DriverInfo driverInfo) {
        LettuceAssert.notNull((Object)driverInfo, "DriverInfo must not be null");
        return new Builder(driverInfo);
    }

    public String getFormattedName() {
        if (this.upstreamDrivers.isEmpty()) {
            return this.name;
        }
        return String.format("%s(%s)", this.name, String.join((CharSequence)";", this.upstreamDrivers));
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getFormattedName();
    }

    private static void validateDriverName(String driverName) {
        DriverInfo.validateNoInvalidCharacters(driverName, "Driver name");
        if (!driverName.matches(DRIVER_NAME_PATTERN)) {
            throw new IllegalArgumentException("Upstream driver name must follow Maven artifactId naming conventions: lowercase letters, digits, hyphens, and underscores only (e.g., 'spring-data-redis', 'lettuce-core')");
        }
    }

    private static void validateDriverVersion(String driverVersion) {
        DriverInfo.validateNoInvalidCharacters(driverVersion, "Driver version");
    }

    private static void validateNoInvalidCharacters(String value, String fieldName) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '!' && c <= '~' && !BRACES.contains(Character.valueOf(c))) continue;
            throw new IllegalArgumentException(fieldName + " must not contain spaces, newlines, non-printable characters, or braces");
        }
    }

    private static String formatDriverInfo(String driverName, String driverVersion) {
        return driverName + "_v" + driverVersion;
    }

    public static class Builder {
        private String name;
        private final List<String> upstreamDrivers;

        private Builder() {
            this.name = LettuceVersion.getName();
            this.upstreamDrivers = new ArrayList<String>();
        }

        private Builder(DriverInfo driverInfo) {
            this.name = driverInfo.name;
            this.upstreamDrivers = new ArrayList<String>(driverInfo.upstreamDrivers);
        }

        public Builder name(String name) {
            LettuceAssert.notNull((Object)name, "Name must not be null");
            this.name = name;
            return this;
        }

        public Builder addUpstreamDriver(String driverName, String driverVersion) {
            LettuceAssert.notNull((Object)driverName, "Driver name must not be null");
            LettuceAssert.notNull((Object)driverVersion, "Driver version must not be null");
            DriverInfo.validateDriverName(driverName);
            DriverInfo.validateDriverVersion(driverVersion);
            String formattedDriverInfo = DriverInfo.formatDriverInfo(driverName, driverVersion);
            this.upstreamDrivers.add(0, formattedDriverInfo);
            return this;
        }

        public DriverInfo build() {
            return new DriverInfo(this.name, this.upstreamDrivers);
        }
    }
}

