/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.time.Duration;
import java.time.Instant;

public class MSetExArgs
implements CompositeArgument {
    private Long ex;
    private Long exAt;
    private Long px;
    private Long pxAt;
    private boolean nx = false;
    private boolean xx = false;
    private boolean keepttl = false;

    public MSetExArgs ex(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        this.ex = timeout.toMillis() / 1000L;
        return this;
    }

    public MSetExArgs exAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        this.exAt = timestamp.toEpochMilli() / 1000L;
        return this;
    }

    public MSetExArgs px(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        this.px = timeout.toMillis();
        return this;
    }

    public MSetExArgs pxAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        this.pxAt = timestamp.toEpochMilli();
        return this;
    }

    public MSetExArgs nx() {
        this.nx = true;
        return this;
    }

    public MSetExArgs keepttl() {
        this.keepttl = true;
        return this;
    }

    public MSetExArgs xx() {
        this.xx = true;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.ex != null) {
            args.add("EX").add(this.ex);
        }
        if (this.exAt != null) {
            args.add("EXAT").add(this.exAt);
        }
        if (this.px != null) {
            args.add("PX").add(this.px);
        }
        if (this.pxAt != null) {
            args.add("PXAT").add(this.pxAt);
        }
        if (this.nx) {
            args.add(CommandKeyword.NX);
        }
        if (this.xx) {
            args.add(CommandKeyword.XX);
        }
        if (this.keepttl) {
            args.add("KEEPTTL");
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static MSetExArgs ex(Duration timeout) {
            return new MSetExArgs().ex(timeout);
        }

        public static MSetExArgs exAt(Instant timestamp) {
            return new MSetExArgs().exAt(timestamp);
        }

        public static MSetExArgs px(Duration timeout) {
            return new MSetExArgs().px(timeout);
        }

        public static MSetExArgs pxAt(Instant timestamp) {
            return new MSetExArgs().pxAt(timestamp);
        }

        public static MSetExArgs nx() {
            return new MSetExArgs().nx();
        }

        public static MSetExArgs xx() {
            return new MSetExArgs().xx();
        }

        public static MSetExArgs keepttl() {
            return new MSetExArgs().keepttl();
        }
    }
}

