/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.internal.ExceptionFactory;
import io.lettuce.core.protocol.CommandExpiryWriter;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.MaintenanceAwareComponent;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.resource.ClientResources;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceAwareExpiryWriter
extends CommandExpiryWriter
implements MaintenanceAwareComponent {
    private static final Logger log = LoggerFactory.getLogger(MaintenanceAwareExpiryWriter.class);
    private final RedisChannelWriter delegate;
    private final TimeoutOptions.TimeoutSource source;
    private final TimeUnit timeUnit;
    private final ScheduledExecutorService executorService;
    private final Timer timer;
    private final boolean applyConnectionTimeout;
    private final Duration relaxedTimeout;
    private volatile boolean relaxTimeouts = false;
    private Timeout relaxTimeout;

    public MaintenanceAwareExpiryWriter(RedisChannelWriter delegate, ClientOptions clientOptions, ClientResources clientResources) {
        super(delegate, clientOptions, clientResources);
        TimeoutOptions timeoutOptions = clientOptions.getTimeoutOptions();
        this.delegate = delegate;
        this.source = timeoutOptions.getSource();
        this.applyConnectionTimeout = timeoutOptions.isApplyConnectionTimeout();
        this.relaxedTimeout = timeoutOptions.getRelaxedTimeout();
        this.timeUnit = this.source.getTimeUnit();
        this.executorService = clientResources.eventExecutorGroup();
        this.timer = clientResources.timer();
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        this.potentiallyExpire(command, this.executorService);
        return this.delegate.write(command);
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> redisCommands) {
        for (RedisCommand<K, V, ?> command : redisCommands) {
            this.potentiallyExpire(command, this.executorService);
        }
        return this.delegate.write(redisCommands);
    }

    private void potentiallyExpire(RedisCommand<?, ?, ?> command, ScheduledExecutorService executors) {
        long timeout;
        long l = timeout = this.applyConnectionTimeout ? this.timeout : this.source.getTimeout(command);
        if (timeout <= 0L) {
            return;
        }
        Timeout commandTimeout = this.timer.newTimeout(t -> {
            if (!command.isDone()) {
                executors.submit(() -> {
                    if (this.relaxTimeouts) {
                        this.relaxedAttempt(command, executors, Duration.ofNanos(this.timeUnit.toNanos(timeout)));
                    } else {
                        command.completeExceptionally(ExceptionFactory.createTimeoutException(command.getType().toString(), Duration.ofNanos(this.timeUnit.toNanos(timeout))));
                    }
                });
            }
        }, timeout, this.timeUnit);
        if (command instanceof CompleteableCommand) {
            ((CompleteableCommand)((Object)command)).onComplete((o, o2) -> commandTimeout.cancel());
        }
    }

    private void relaxedAttempt(RedisCommand<?, ?, ?> command, ScheduledExecutorService executors, Duration initialTimeout) {
        Timeout commandTimeout = this.timer.newTimeout(t -> {
            if (!command.isDone()) {
                executors.submit(() -> command.completeExceptionally(ExceptionFactory.createTimeoutException(initialTimeout.plus(this.relaxedTimeout))));
            }
        }, this.relaxedTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (command instanceof CompleteableCommand) {
            ((CompleteableCommand)((Object)command)).onComplete((o, o2) -> commandTimeout.cancel());
        }
    }

    @Override
    public void onRebindStarted(Duration time, SocketAddress endpoint) {
        this.enableRelaxedTimeout("Re-bind started");
    }

    @Override
    public void onRebindCompleted() {
        this.disableRelaxedTimeoutDelayed("Re-bind completed", this.relaxedTimeout);
    }

    @Override
    public void onMigrateStarted(String shards) {
        this.enableRelaxedTimeout("Migration started for shards: " + shards);
    }

    @Override
    public void onMigrateCompleted(String shards) {
        this.disableRelaxedTimeoutDelayed("Migration completed: " + shards, this.relaxedTimeout);
    }

    @Override
    public void onFailoverStarted(String shards) {
        this.enableRelaxedTimeout("Failover started for shards: " + shards);
    }

    @Override
    public void onFailoverCompleted(String shards) {
        this.disableRelaxedTimeoutDelayed("Failover completed: " + shards, this.relaxedTimeout);
    }

    private void enableRelaxedTimeout(String reason) {
        if (this.relaxTimeout != null) {
            boolean canceled = this.relaxTimeout.cancel();
            log.debug("Canceled previous disable relax timeout task : {}", (Object)canceled);
        }
        if (!this.relaxedTimeout.isNegative()) {
            log.info("{}, relaxing timeouts with an additional {}ms", (Object)reason, (Object)this.relaxedTimeout.toMillis());
            this.relaxTimeouts = true;
        } else {
            log.debug("{}, but timeout relaxing is disabled", (Object)reason);
            this.relaxTimeouts = false;
        }
    }

    private void disableRelaxedTimeoutDelayed(String reason, Duration gracePeriod) {
        if (this.relaxTimeout != null) {
            boolean canceled = this.relaxTimeout.cancel();
            log.debug("Canceled previous disable relax timeout task : {}", (Object)canceled);
        }
        log.debug("{}, scheduling timeout relaxation disable after {}ms", (Object)reason, (Object)gracePeriod.toMillis());
        this.relaxTimeout = this.timer.newTimeout(t -> this.executorService.submit(() -> {
            log.debug("Disabling timeout relaxation after {}", (Object)reason);
            this.relaxTimeouts = false;
        }), gracePeriod.toMillis(), TimeUnit.MILLISECONDS);
    }
}

