/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search;

import io.lettuce.core.annotations.Experimental;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Experimental
public class HybridReply<K, V> {
    private long totalResults = 0L;
    private double executionTime = 0.0;
    private final List<Result<K, V>> results;
    private final List<V> warnings = new ArrayList<V>();

    public HybridReply() {
        this.results = new ArrayList<Result<K, V>>();
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public void setTotalResults(long totalResults) {
        this.totalResults = totalResults;
    }

    public double getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(double executionTime) {
        this.executionTime = executionTime;
    }

    public List<Result<K, V>> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public void addResult(Result<K, V> result) {
        this.results.add(result);
    }

    public List<V> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public void addWarning(V warning) {
        this.warnings.add(warning);
    }

    public int size() {
        return this.results.size();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public static class Result<K, V> {
        private final Map<K, V> fields = new HashMap();

        public Map<K, V> getFields() {
            return this.fields;
        }

        public void addField(K key, V value) {
            this.fields.put(key, value);
        }
    }
}

