/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Experimental
public class HybridVectorArgs<K, V> {
    private final K fieldName;
    private final V vectorData;
    private final VectorSearchMethod method;
    private final List<String> filters;
    private final K scoreAlias;

    private HybridVectorArgs(Builder<K, V> builder) {
        this.fieldName = ((Builder)builder).fieldName;
        this.vectorData = ((Builder)builder).vectorData;
        this.method = ((Builder)builder).method;
        this.filters = new ArrayList<String>(((Builder)builder).filters);
        this.scoreAlias = ((Builder)builder).scoreAlias;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public K getFieldName() {
        return this.fieldName;
    }

    public V getVectorData() {
        return this.vectorData;
    }

    public Optional<VectorSearchMethod> getMethod() {
        return Optional.ofNullable(this.method);
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public Optional<K> getScoreAlias() {
        return Optional.ofNullable(this.scoreAlias);
    }

    public void build(CommandArgs<K, V> args) {
        args.add(CommandType.VSIM);
        args.addKey(this.fieldName);
        if (this.vectorData instanceof byte[]) {
            args.add((byte[])this.vectorData);
        } else {
            args.addValue(this.vectorData);
        }
        if (this.method != null) {
            this.method.build(args);
        }
        for (String filter : this.filters) {
            args.add(CommandKeyword.FILTER);
            args.add(filter);
        }
        if (this.scoreAlias != null) {
            args.add(CommandKeyword.YIELD_SCORE_AS);
            args.addKey(this.scoreAlias);
        }
    }

    public static class Range
    implements VectorSearchMethod {
        private final double radius;
        private Double epsilon;

        private Range(double radius) {
            LettuceAssert.isTrue(radius > 0.0, "Radius must be positive");
            this.radius = radius;
        }

        public static Range of(double radius) {
            return new Range(radius);
        }

        public Range epsilon(double epsilon) {
            LettuceAssert.isTrue(epsilon > 0.0, "Epsilon must be positive");
            this.epsilon = epsilon;
            return this;
        }

        @Override
        public <K, V> void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.RANGE);
            int pairCount = this.epsilon != null ? 4 : 2;
            args.add(pairCount);
            args.add(CommandKeyword.RADIUS);
            args.add(this.radius);
            if (this.epsilon != null) {
                args.add(CommandKeyword.EPSILON);
                args.add(this.epsilon);
            }
        }
    }

    public static class Knn
    implements VectorSearchMethod {
        private final int k;
        private Integer efRuntime;

        private Knn(int k) {
            LettuceAssert.isTrue(k > 0, "K must be positive");
            this.k = k;
        }

        public static Knn of(int k) {
            return new Knn(k);
        }

        public Knn efRuntime(int efRuntime) {
            LettuceAssert.isTrue(efRuntime > 0, "EF_RUNTIME must be positive");
            this.efRuntime = efRuntime;
            return this;
        }

        @Override
        public <K, V> void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.KNN);
            int itemCount = this.efRuntime != null ? 4 : 2;
            args.add(itemCount);
            args.add(CommandKeyword.K);
            args.add(this.k);
            if (this.efRuntime != null) {
                args.add(CommandKeyword.EF_RUNTIME);
                args.add(this.efRuntime.intValue());
            }
        }
    }

    public static interface VectorSearchMethod {
        public <K, V> void build(CommandArgs<K, V> var1);
    }

    public static class Builder<K, V> {
        private K fieldName;
        private V vectorData;
        private VectorSearchMethod method;
        private final List<String> filters = new ArrayList<String>();
        private K scoreAlias;

        public Builder<K, V> field(K fieldName) {
            LettuceAssert.notNull(fieldName, "Field name must not be null");
            this.fieldName = fieldName;
            return this;
        }

        public Builder<K, V> vector(V vectorData) {
            LettuceAssert.notNull(vectorData, "Vector data must not be null");
            this.vectorData = vectorData;
            return this;
        }

        public Builder<K, V> vector(byte[] vectorData) {
            LettuceAssert.notNull((Object)vectorData, "Vector data must not be null");
            this.vectorData = (V)vectorData;
            return this;
        }

        public Builder<K, V> method(VectorSearchMethod method) {
            LettuceAssert.notNull((Object)method, "Vector search method must not be null");
            this.method = method;
            return this;
        }

        public Builder<K, V> filter(String expression) {
            LettuceAssert.notNull((Object)expression, "Filter expression must not be null");
            this.filters.add(expression);
            return this;
        }

        public Builder<K, V> scoreAlias(K alias) {
            LettuceAssert.notNull(alias, "Score alias must not be null");
            this.scoreAlias = alias;
            return this;
        }

        public HybridVectorArgs<K, V> build() {
            LettuceAssert.notNull(this.fieldName, "Field name must not be null");
            LettuceAssert.notNull(this.vectorData, "Vector data must not be null");
            return new HybridVectorArgs(this);
        }
    }
}

