/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.ByteRange;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

class ByteRangeBuilder {
    private static final long INIT_BIT_LENGTH = 1L;
    private long initBits = 1L;
    private long length;
    private Long offset;

    ByteRangeBuilder() {
        if (!(this instanceof ByteRange.Builder)) {
            throw new UnsupportedOperationException("Use: new ByteRange.Builder()");
        }
    }

    public final ByteRange.Builder from(ByteRange instance) {
        Objects.requireNonNull(instance, "instance");
        this.length(instance.length());
        Optional<Long> offsetOptional = instance.offset();
        if (offsetOptional.isPresent()) {
            this.offset(offsetOptional);
        }
        return (ByteRange.Builder)this;
    }

    public final ByteRange.Builder length(long length) {
        this.length = length;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (ByteRange.Builder)this;
    }

    public final ByteRange.Builder offset(long offset) {
        this.offset = offset;
        return (ByteRange.Builder)this;
    }

    public final ByteRange.Builder offset(Optional<Long> offset) {
        this.offset = offset.orElse(null);
        return (ByteRange.Builder)this;
    }

    public ByteRange build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableByteRange(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("length");
        }
        return "Cannot build ByteRange, some of required attributes are not set " + attributes;
    }

    private static final class ImmutableByteRange
    implements ByteRange {
        private final long length;
        private final Long offset;

        private ImmutableByteRange(ByteRangeBuilder builder) {
            this.length = builder.length;
            this.offset = builder.offset;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public Optional<Long> offset() {
            return Optional.ofNullable(this.offset);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableByteRange && this.equalTo((ImmutableByteRange)another);
        }

        private boolean equalTo(ImmutableByteRange another) {
            return this.length == another.length && Objects.equals(this.offset, another.offset);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Long.hashCode(this.length);
            h += (h << 5) + Objects.hashCode(this.offset);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ByteRange{");
            builder.append("length=").append(this.length);
            if (this.offset != null) {
                builder.append(", ");
                builder.append("offset=").append(this.offset);
            }
            return builder.append("}").toString();
        }
    }
}

