/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.ContentSteering;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

class ContentSteeringBuilder {
    private static final long INIT_BIT_SERVER_URI = 1L;
    private long initBits = 1L;
    private String serverUri;
    private String pathwayId;

    ContentSteeringBuilder() {
        if (!(this instanceof ContentSteering.Builder)) {
            throw new UnsupportedOperationException("Use: new ContentSteering.Builder()");
        }
    }

    public final ContentSteering.Builder from(ContentSteering instance) {
        Objects.requireNonNull(instance, "instance");
        this.serverUri(instance.serverUri());
        Optional<String> pathwayIdOptional = instance.pathwayId();
        if (pathwayIdOptional.isPresent()) {
            this.pathwayId(pathwayIdOptional);
        }
        return (ContentSteering.Builder)this;
    }

    public final ContentSteering.Builder serverUri(String serverUri) {
        this.serverUri = Objects.requireNonNull(serverUri, "serverUri");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (ContentSteering.Builder)this;
    }

    public final ContentSteering.Builder pathwayId(String pathwayId) {
        this.pathwayId = Objects.requireNonNull(pathwayId, "pathwayId");
        return (ContentSteering.Builder)this;
    }

    public final ContentSteering.Builder pathwayId(Optional<String> pathwayId) {
        this.pathwayId = pathwayId.orElse(null);
        return (ContentSteering.Builder)this;
    }

    public ContentSteering build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableContentSteering(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("serverUri");
        }
        return "Cannot build ContentSteering, some of required attributes are not set " + attributes;
    }

    private static final class ImmutableContentSteering
    implements ContentSteering {
        private final String serverUri;
        private final String pathwayId;

        private ImmutableContentSteering(ContentSteeringBuilder builder) {
            this.serverUri = builder.serverUri;
            this.pathwayId = builder.pathwayId;
        }

        @Override
        public String serverUri() {
            return this.serverUri;
        }

        @Override
        public Optional<String> pathwayId() {
            return Optional.ofNullable(this.pathwayId);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableContentSteering && this.equalTo((ImmutableContentSteering)another);
        }

        private boolean equalTo(ImmutableContentSteering another) {
            return this.serverUri.equals(another.serverUri) && Objects.equals(this.pathwayId, another.pathwayId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.serverUri.hashCode();
            h += (h << 5) + Objects.hashCode(this.pathwayId);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ContentSteering{");
            builder.append("serverUri=").append(this.serverUri);
            if (this.pathwayId != null) {
                builder.append(", ");
                builder.append("pathwayId=").append(this.pathwayId);
            }
            return builder.append("}").toString();
        }
    }
}

