/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.utils;

import io.meeds.analytics.api.service.StatisticDataQueueService;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils$AjcClosure1;
import io.meeds.analytics.utils.AnalyticsUtils$AjcClosure3;
import io.meeds.analytics.utils.AnalyticsUtils$AjcClosure5;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.service.CategoryService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsUtils {
    private static final Log LOG;
    public static final short MAX_BULK_DOCUMENTS = 100;
    public static final String VALUES_SEPARATOR = ",";
    public static final String FIELD_IS_ANALYTICS = "isAnalytics";
    public static final String FIELD_ERROR_MESSAGE = "errorMessage";
    public static final String FIELD_ERROR_CODE = "errorCode";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_OPERATION = "operation";
    public static final String FIELD_SUB_MODULE = "subModule";
    public static final String FIELD_MODULE = "module";
    public static final String FIELD_SPACE_ID = "spaceId";
    public static final String FIELD_DURATION = "duration";
    public static final String FIELD_USER_ID = "userId";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_MODIFIER_USER_SOCIAL_ID = "modifierSocialId";
    public static final String FIELD_SOCIAL_IDENTITY_ID = "identityId";
    public static final String LINK_ACTIVITY_TYPE = "LINK_ACTIVITY";
    public static final String FILE_SPACES_ACTIVITY_TYPE = "files:spaces";
    public static final String ACTIVITY_COMMENT = "comment";
    public static final List<String> COMPUTED_CHART_LABEL;
    public static final DateTimeFormatter DATE_FORMATTER;
    public static final List<String> DEFAULT_FIELDS;
    private static final Pattern JSON_CLEANER_REPLACEMENT_PATTERN;
    public static final DateTimeFormatter YEAR_WEEK;
    public static final DateTimeFormatter YEAR_MONTH;
    public static final DateTimeFormatter YEAR_MONTH_DATE_HOUR;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    private AnalyticsUtils() {
    }

    public static final String getYearMonthDayHour(long timestamp) {
        LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        return AnalyticsUtils.getYearMonthDayHour(date);
    }

    public static final String getYearMonthDayHour(LocalDateTime date) {
        return YEAR_MONTH_DATE_HOUR.format(date);
    }

    public static final String getYearMonthDay(long timestamp) {
        LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        return AnalyticsUtils.getYearMonthDay(date);
    }

    public static final String getYearMonthDay(LocalDateTime date) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(date);
    }

    public static final String getYearMonth(long timestamp) {
        LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        return AnalyticsUtils.getYearMonth(date);
    }

    public static final String getYearMonth(LocalDateTime date) {
        return YEAR_MONTH.format(date);
    }

    public static final String getYearWeek(long timestamp) {
        LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        return AnalyticsUtils.getYearWeek(date);
    }

    public static final String getYearWeek(LocalDateTime date) {
        return YEAR_WEEK.format(date);
    }

    public static final String toJsonString(Object object) {
        try {
            if (object instanceof Collection) {
                return new JsonGeneratorImpl().createJsonArray((Collection)object).toString();
            }
            return new JsonGeneratorImpl().createJsonObject(object).toString();
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error parsing object to string " + String.valueOf(object), e);
        }
    }

    public static final String compueLabel(String chartKey, String chartValue) {
        String defaultLabel = (String)(chartKey == null ? "" : chartKey.replace(".keyword", "") + "=") + chartValue;
        if (StringUtils.isBlank((CharSequence)chartKey) || StringUtils.isBlank((CharSequence)chartValue) || !COMPUTED_CHART_LABEL.contains(chartKey)) {
            return defaultLabel;
        }
        if (StringUtils.equals((CharSequence)chartKey, (CharSequence)FIELD_SPACE_ID)) {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceById(chartValue);
            if (space == null) {
                return defaultLabel;
            }
            return space.getDisplayName();
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        if (identityManager == null) {
            return defaultLabel;
        }
        Identity identity = AnalyticsUtils.getIdentity(chartValue);
        if (identity == null) {
            return defaultLabel;
        }
        return identity.getProfile().getFullName();
    }

    public static final <T> T fromJsonString(String value, Class<T> resultClass) {
        try {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
            new JsonParserImpl().parse((InputStream)new ByteArrayInputStream(value.getBytes()), (JsonHandler)jsonDefaultHandler);
            return (T)ObjectBuilder.createObject(resultClass, (JsonValue)jsonDefaultHandler.getJsonObject());
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error creating object from string : " + value, e);
        }
    }

    public static long timeToMilliseconds(LocalDateTime time) {
        return time.atZone(ZoneId.systemDefault()).toEpochSecond() * 1000L;
    }

    public static final String fixJSONStringFormat(String jsonString) {
        while (JSON_CLEANER_REPLACEMENT_PATTERN.matcher(jsonString = jsonString.replaceAll("([,\\]}][ \\t]+)", "$1").replaceAll(" +([,\\]}])", "$1").replace("\n", "").replaceAll(",+", VALUES_SEPARATOR).replaceAll("([\\]}]+),([\\]}]+)", "$1$2")).find()) {
        }
        return jsonString;
    }

    public static final String collectionToJSONString(String value) {
        String[] valuesString = value.split(VALUES_SEPARATOR);
        ArrayList valuesList = new ArrayList();
        Collections.addAll(valuesList, valuesString);
        return new JSONArray(valuesList.stream().map(String::trim).toList()).toString();
    }

    public static final JSONObject getJSONObject(JSONObject jsonObject, int i, String ... keys) {
        if (keys == null || i >= keys.length) {
            return null;
        }
        try {
            if (keys[i] == null) {
                Object[] names = JSONObject.getNames((JSONObject)jsonObject);
                if (ArrayUtils.isNotEmpty((Object[])names)) {
                    ++i;
                    JSONObject resultJsonObject = new JSONObject();
                    for (int j = 0; j < names.length; ++j) {
                        Object name = names[j];
                        JSONObject subJsonObject = jsonObject.getJSONObject((String)name);
                        JSONObject resultSubJsonObject = AnalyticsUtils.getJSONObject(subJsonObject, i, keys);
                        String[] attributes = JSONObject.getNames((JSONObject)resultSubJsonObject);
                        for (int k = 0; k < attributes.length; ++k) {
                            String attribute = attributes[k];
                            resultJsonObject.put(attribute, resultSubJsonObject.get(attribute));
                        }
                    }
                    return resultJsonObject;
                }
                return null;
            }
            if (jsonObject.has(keys[i])) {
                jsonObject = jsonObject.getJSONObject(keys[i]);
                if (++i == keys.length) {
                    return jsonObject;
                }
                return AnalyticsUtils.getJSONObject(jsonObject, i, keys);
            }
            return null;
        }
        catch (JSONException e) {
            LOG.warn("Error getting key object with {}", new Object[]{keys[i], e});
            return null;
        }
    }

    @ExoTransactional
    public static final void addStatisticData(StatisticData statisticData) {
        StatisticData statisticData2 = statisticData;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)statisticData2);
        Object[] objectArray = new Object[]{statisticData2, joinPoint};
        AnalyticsUtils$AjcClosure1 analyticsUtils$AjcClosure1 = new AnalyticsUtils$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(analyticsUtils$AjcClosure1.linkClosureAndJoinPoint(65536));
    }

    public static long getUserIdentityId(String username) {
        return AnalyticsUtils.getIdentityId("organization", username);
    }

    public static Space getSpaceByPrettyName(String prettyName) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        return spaceService.getSpaceByPrettyName(prettyName);
    }

    public static Space getSpaceById(String spaceId) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        return spaceService.getSpaceById(spaceId);
    }

    public static Identity getIdentity(String identityIdString) {
        if (StringUtils.isBlank((CharSequence)identityIdString)) {
            return null;
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        long identityId = AnalyticsUtils.parseId(identityIdString);
        return identityId > 0L ? identityManager.getIdentity(identityId) : null;
    }

    public static long getIdentityId(String identityId) {
        Identity identity = AnalyticsUtils.getIdentity(identityId);
        return identity == null ? 0L : Long.parseLong(identity.getId());
    }

    @ExoTransactional
    public static Identity getIdentity(String providerId, String remoteId) {
        String string = providerId;
        String string2 = remoteId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{string, string2, joinPoint};
        AnalyticsUtils$AjcClosure3 analyticsUtils$AjcClosure3 = new AnalyticsUtils$AjcClosure3(objectArray);
        return (Identity)ExoTransactionalAspect.aspectOf().around(analyticsUtils$AjcClosure3.linkClosureAndJoinPoint(65536));
    }

    public static long getIdentityId(String providerId, String remoteId) {
        Identity identity = AnalyticsUtils.getIdentity(providerId, remoteId);
        return identity == null ? 0L : Long.parseLong(identity.getId());
    }

    @ExoTransactional
    public static long getUserIdentityId(ConversationState currentState) {
        ConversationState conversationState = currentState;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)conversationState);
        Object[] objectArray = new Object[]{conversationState, joinPoint};
        AnalyticsUtils$AjcClosure5 analyticsUtils$AjcClosure5 = new AnalyticsUtils$AjcClosure5(objectArray);
        return Conversions.longValue((Object)ExoTransactionalAspect.aspectOf().around(analyticsUtils$AjcClosure5.linkClosureAndJoinPoint(65536)));
    }

    public static long getCurrentUserIdentityId() {
        ConversationState currentState = ConversationState.getCurrent();
        return AnalyticsUtils.getUserIdentityId(currentState);
    }

    public static boolean isUnkownUser(String username) {
        return username == null || StringUtils.equals((CharSequence)username, (CharSequence)IdentityConstants.ANONIM) || StringUtils.equals((CharSequence)username, (CharSequence)IdentityConstants.SYSTEM);
    }

    public static String getUsername(ConversationState currentState) {
        return currentState == null || currentState.getIdentity() == null || currentState.getIdentity().getUserId() == null ? null : currentState.getIdentity().getUserId();
    }

    public static String formatDate(long timeInMilliseconds) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(String.valueOf(timeInMilliseconds))), TimeZone.getDefault().toZoneId());
        return dateTime.format(DATE_FORMATTER);
    }

    public static void addSpaceStatistics(StatisticData statisticData, Space space) {
        if (space == null || StringUtils.isBlank((CharSequence)space.getId())) {
            return;
        }
        statisticData.setSpaceId(Long.parseLong(space.getId()));
        statisticData.addParameter("spaceTemplateId", space.getTemplateId());
        statisticData.addParameter("spaceCategoryIds", space.getCategoryIds());
        statisticData.addParameter("spaceVisibility", space.getVisibility());
        statisticData.addParameter("spaceRegistration", space.getRegistration());
        statisticData.addParameter("spaceCreatedTime", space.getCreatedTime());
        statisticData.addParameter("spaceMembersCount", AnalyticsUtils.getSize(space.getMembers()));
        statisticData.addParameter("spaceManagersCount", AnalyticsUtils.getSize(space.getManagers()));
        statisticData.addParameter("spaceRedactorsCount", AnalyticsUtils.getSize(space.getRedactors()));
        statisticData.addParameter("spaceInviteesCount", AnalyticsUtils.getSize(space.getInvitedUsers()));
        statisticData.addParameter("spacePendingCount", AnalyticsUtils.getSize(space.getPendingUsers()));
    }

    public static void addActivityStatisticsData(StatisticData statisticData, ExoSocialActivity activity) {
        if (activity == null || StringUtils.isBlank((CharSequence)activity.getId())) {
            return;
        }
        String activityId = activity.getParentId() == null ? activity.getId() : activity.getParentId();
        String commentId = activity.getParentCommentId() == null ? activity.getId() : activity.getParentCommentId();
        String subCommentId = activity.getParentCommentId() == null ? null : activity.getId();
        statisticData.addParameter("activityType", AnalyticsUtils.getActivityType(activity));
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            statisticData.addParameter("activityId", activityId);
        }
        if (StringUtils.isNotBlank((CharSequence)commentId)) {
            commentId = commentId.replace(ACTIVITY_COMMENT, "");
            statisticData.addParameter(ACTIVITY_COMMENT, commentId);
        }
        if (StringUtils.isNotBlank((CharSequence)subCommentId)) {
            subCommentId = subCommentId.replace(ACTIVITY_COMMENT, "");
            statisticData.addParameter("subCommentId", subCommentId);
        }
    }

    public static void addCategoryStatistics(StatisticData statisticData, long categoryId) {
        CategoryService categoryService = (CategoryService)ExoContainerContext.getService(CategoryService.class);
        AnalyticsUtils.addCategoryStatistics(statisticData, categoryService.getCategory(categoryId));
    }

    public static void addCategoryStatistics(StatisticData statisticData, Category category) {
        if (category == null) {
            return;
        }
        statisticData.addParameter("categoryId", category.getId());
        statisticData.addParameter("categoryIcon", category.getIcon());
        statisticData.addParameter("categoryAccessPermissionIds", category.getAccessPermissionIds());
        statisticData.addParameter("categoryLinkPermissionIds", category.getLinkPermissionIds());
        statisticData.addParameter("categoryCreatorId", category.getCreatorId());
        statisticData.addParameter("categoryOwnerId", category.getOwnerId());
        statisticData.addParameter("categoryParentId", category.getParentId());
    }

    public static void addCategoryLinkStatistics(StatisticData statisticData, CategoryObject categoryObject) {
        SpaceService spaceService;
        Space space;
        statisticData.addParameter("categoryObjectType", categoryObject.getType());
        statisticData.addParameter("categoryObjectId", categoryObject.getId());
        statisticData.addParameter("categoryObjectParentId", categoryObject.getParentId());
        if (categoryObject.getSpaceId() > 0L && (space = (spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class)).getSpaceById(categoryObject.getSpaceId())) != null) {
            AnalyticsUtils.addSpaceStatistics(statisticData, space);
        }
    }

    private static int getSize(String[] array) {
        return array == null ? 0 : (int)Arrays.stream(array).filter(Objects::nonNull).distinct().count();
    }

    private static String getActivityType(ExoSocialActivity activity) {
        String type = activity.getType();
        if (type == null || type.isEmpty()) {
            if (activity.getFiles() != null && !activity.getFiles().isEmpty()) {
                type = FILE_SPACES_ACTIVITY_TYPE;
            } else if (!(activity.getFiles() != null && !activity.getFiles().isEmpty() || activity.getTemplateParams() == null || activity.getTemplateParams().isEmpty() || activity.getTemplateParams().get("link") == null || ((String)activity.getTemplateParams().get("link")).equals("-"))) {
                type = LINK_ACTIVITY_TYPE;
            }
        }
        return type;
    }

    public static long parseId(String id) {
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    static {
        AnalyticsUtils.ajc$preClinit();
        LOG = ExoLogger.getLogger(AnalyticsUtils.class);
        COMPUTED_CHART_LABEL = Arrays.asList(FIELD_MODIFIER_USER_SOCIAL_ID, FIELD_SOCIAL_IDENTITY_ID, FIELD_USER_ID, FIELD_SPACE_ID);
        DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu/MM/dd HH:mm:ss");
        DEFAULT_FIELDS = Arrays.asList(FIELD_IS_ANALYTICS, FIELD_ERROR_MESSAGE, FIELD_ERROR_CODE, FIELD_STATUS, FIELD_OPERATION, FIELD_MODULE, FIELD_SUB_MODULE, FIELD_SPACE_ID, FIELD_USER_ID, FIELD_TIMESTAMP);
        JSON_CLEANER_REPLACEMENT_PATTERN = Pattern.compile("([\\]}]+),([\\]}]+)");
        YEAR_WEEK = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(IsoFields.WEEK_BASED_YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2).optionalStart().appendOffsetId().toFormatter();
        YEAR_MONTH = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();
        YEAR_MONTH_DATE_HOUR = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).toFormatter();
    }

    static final /* synthetic */ void addStatisticData_aroundBody0(StatisticData statisticData, JoinPoint joinPoint) {
        if (statisticData == null || statisticData.getOperation() == null) {
            return;
        }
        if (statisticData.getTimestamp() <= 0L) {
            statisticData.setTimestamp(System.currentTimeMillis());
        }
        if (statisticData.getStatus() == null) {
            statisticData.setStatus(StatisticData.StatisticStatus.OK);
        }
        if (statisticData.getUserId() == 0L && ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null) {
            statisticData.setUserId(AnalyticsUtils.getIdentityId("organization", ConversationState.getCurrent().getIdentity().getUserId()));
        }
        try {
            StatisticDataQueueService analyticsQueueService = (StatisticDataQueueService)CommonsUtils.getService(StatisticDataQueueService.class);
            analyticsQueueService.put(statisticData);
        }
        catch (Exception e) {
            LOG.warn("Error adding analytics Queue entry: {}", new Object[]{statisticData, e});
        }
    }

    static final /* synthetic */ Identity getIdentity_aroundBody2(String providerId, String remoteId, JoinPoint joinPoint) {
        if (StringUtils.isBlank((CharSequence)remoteId)) {
            return null;
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return identityManager.getOrCreateIdentity(providerId, remoteId);
    }

    static final /* synthetic */ long getUserIdentityId_aroundBody4(ConversationState currentState, JoinPoint joinPoint) {
        String username = AnalyticsUtils.getUsername(currentState);
        boolean unkownUser = AnalyticsUtils.isUnkownUser(username);
        if (unkownUser) {
            return 0L;
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getOrCreateIdentity("organization", username);
        return identity == null ? 0L : Long.parseLong(identity.getId());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AnalyticsUtils.java", AnalyticsUtils.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("19", "addStatisticData", "io.meeds.analytics.utils.AnalyticsUtils", "io.meeds.analytics.model.StatisticData", "statisticData", "", "void"), 332);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getIdentity", "io.meeds.analytics.utils.AnalyticsUtils", "java.lang.String:java.lang.String", "providerId:remoteId", "", "org.exoplatform.social.core.identity.model.Identity"), 386);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getUserIdentityId", "io.meeds.analytics.utils.AnalyticsUtils", "org.exoplatform.services.security.ConversationState", "currentState", "", "long"), 400);
    }
}

