/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.storage;

import io.meeds.appcenter.dao.ApplicationDAO;
import io.meeds.appcenter.dao.FavoriteApplicationDAO;
import io.meeds.appcenter.entity.ApplicationEntity;
import io.meeds.appcenter.entity.FavoriteApplicationEntity;
import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationImage;
import io.meeds.appcenter.model.UserApplication;
import io.meeds.appcenter.model.exception.ApplicationNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ApplicationCenterStorage {
    private static final String APPLICATION_NOT_FOUND_MESSAGE = "Application with id %s doesn't exist";
    private static final String APPLICATION_ID_IS_MANDATORY_MESSAGE = "applicationId is mandatory";
    private static final String USERNAME_IS_MANDATORY_MESSAGE = "username is mandatory";
    public static final String NAME_SPACE = "appCenter";
    public static final Long DEFAULT_LAST_MODIFIED = System.currentTimeMillis();
    @Autowired
    private FileService fileService;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private FavoriteApplicationDAO favoriteApplicationDAO;

    public Application getApplicationByTitle(String title) {
        if (StringUtils.isBlank((CharSequence)title)) {
            throw new IllegalArgumentException("title is mandatory");
        }
        ApplicationEntity applicationentity = this.applicationDAO.getApplicationByTitle(title);
        return this.toDTO(applicationentity);
    }

    public Application createApplication(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("application is mandatory");
        }
        ApplicationEntity applicationEntity = this.toEntity(application);
        applicationEntity.setId(null);
        ApplicationImage applicationImage = this.createAppImageFileItem(application.getImageFileName(), application.getImageFileBody());
        if (applicationImage != null) {
            applicationEntity.setImageFileId(applicationImage.getId());
        }
        applicationEntity = (ApplicationEntity)this.applicationDAO.save(applicationEntity);
        return this.toDTO(applicationEntity);
    }

    public Application updateApplication(Application application) throws ApplicationNotFoundException {
        boolean newImageAttached;
        if (application == null) {
            throw new IllegalArgumentException("application is mandatory");
        }
        Long applicationId = application.getId();
        ApplicationEntity storedApplicationEntity = this.applicationDAO.findById(applicationId).orElse(null);
        if (storedApplicationEntity == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        application.setSystem(storedApplicationEntity.isSystem());
        Long oldImageFileId = storedApplicationEntity.getImageFileId();
        boolean imageRemoved = StringUtils.isBlank((CharSequence)application.getImageFileBody()) && StringUtils.isBlank((CharSequence)application.getImageFileName()) && oldImageFileId != null && oldImageFileId > 0L;
        boolean bl = newImageAttached = StringUtils.isNotBlank((CharSequence)application.getImageFileBody()) && StringUtils.isNotBlank((CharSequence)application.getImageFileName());
        if (newImageAttached) {
            ApplicationImage applicationImage = this.createAppImageFileItem(application.getImageFileName(), application.getImageFileBody());
            if (applicationImage != null) {
                application.setImageFileId(applicationImage.getId());
                if (oldImageFileId != null && oldImageFileId > 0L) {
                    this.fileService.deleteFile(oldImageFileId.longValue());
                }
            }
        } else {
            application.setImageFileId(oldImageFileId);
        }
        if (imageRemoved) {
            application.setImageFileId(null);
            this.fileService.deleteFile(oldImageFileId.longValue());
        }
        if (application.isMandatory()) {
            this.favoriteApplicationDAO.removeAllFavoritesOfApplication(application.getId());
        }
        ApplicationEntity applicationEntity = this.toEntity(application);
        applicationEntity = (ApplicationEntity)this.applicationDAO.save(applicationEntity);
        return this.toDTO(applicationEntity);
    }

    public void deleteApplication(long applicationId) throws ApplicationNotFoundException {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        ApplicationEntity applicationEntity = this.applicationDAO.findById(applicationId).orElse(null);
        if (applicationEntity == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        this.applicationDAO.delete(applicationEntity);
    }

    public Application getApplicationById(long applicationId) {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        ApplicationEntity applicationEntity = this.applicationDAO.findById(applicationId).orElse(null);
        return this.toDTO(applicationEntity);
    }

    public void addApplicationToUserFavorite(long applicationId, String username) throws ApplicationNotFoundException {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        ApplicationEntity application = this.applicationDAO.findById(applicationId).orElse(null);
        if (application == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        this.favoriteApplicationDAO.save(new FavoriteApplicationEntity(application, username));
    }

    public void updateFavoriteApplicationOrder(long applicationId, String username, Long order) throws ApplicationNotFoundException {
        FavoriteApplicationEntity entity = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username);
        if (entity == null) {
            this.addApplicationToUserFavorite(applicationId, username);
            entity = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username);
        }
        entity.setOrder(order);
        this.favoriteApplicationDAO.save(entity);
    }

    public void deleteApplicationFavorite(Long applicationId, String username) {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        FavoriteApplicationEntity applicationFavorite = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username);
        if (applicationFavorite != null) {
            this.favoriteApplicationDAO.delete(applicationFavorite);
        }
    }

    public List<UserApplication> getMandatoryApplications() {
        List<ApplicationEntity> applications = this.applicationDAO.getMandatoryActiveApps();
        return applications.stream().map(this::toUserApplicationDTO).toList();
    }

    public List<UserApplication> getFavoriteApplicationsByUser(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        List<FavoriteApplicationEntity> applications = this.favoriteApplicationDAO.getFavoriteAppsByUser(username);
        return applications.stream().map(this::toUserApplicationDTO).filter(Application::isActive).toList();
    }

    public List<Application> getSystemApplications() {
        List<ApplicationEntity> applications = this.applicationDAO.getSystemApplications();
        ArrayList<Application> list = new ArrayList<Application>();
        Application application = null;
        for (ApplicationEntity entity : applications) {
            application = this.toDTO(entity);
            list.add(application);
        }
        return list;
    }

    public boolean isFavoriteApplication(Long applicationId, String username) {
        if (applicationId == null || applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        return this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username) != null;
    }

    public long countFavorites(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        return this.favoriteApplicationDAO.countFavoritesForUser(username);
    }

    public ApplicationImage saveAppImageFileItem(ApplicationImage defaultAppImage) {
        if (defaultAppImage == null) {
            throw new IllegalArgumentException("Application image is mandatory");
        }
        if (defaultAppImage.getId() == null || defaultAppImage.getId() <= 0L) {
            return this.createAppImageFileItem(defaultAppImage.getFileName(), defaultAppImage.getFileBody());
        }
        return this.updateAppImageFileItem(defaultAppImage.getId(), defaultAppImage.getFileName(), defaultAppImage.getFileBody());
    }

    public ApplicationImage createAppImageFileItem(String fileName, String fileBody) {
        return this.updateAppImageFileItem(null, fileName, fileBody);
    }

    public Long getApplicationImageLastUpdated(long fileId) {
        FileItem fileItem = this.fileService.getFile(fileId);
        if (fileItem != null && fileItem.getFileInfo().getUpdatedDate() != null) {
            return fileItem.getFileInfo().getUpdatedDate().getTime();
        }
        return null;
    }

    public InputStream getApplicationImageInputStream(long fileId) {
        FileItem fileItem = this.fileService.getFile(fileId);
        if (fileItem != null && fileItem.getAsByte() != null) {
            return new ByteArrayInputStream(fileItem.getAsByte());
        }
        return null;
    }

    public ApplicationImage getAppImageFile(Long fileId) {
        FileItem fileItem = this.fileService.getFile(fileId.longValue());
        if (fileItem != null) {
            byte[] bytes = fileItem.getAsByte();
            String fileBody = new String(Base64.getEncoder().encode(bytes), Charset.defaultCharset());
            String fileName = fileItem.getFileInfo().getName();
            return new ApplicationImage(fileId, fileName, fileBody);
        }
        return null;
    }

    public List<Application> getApplications(String keyword) {
        List<ApplicationEntity> applications = StringUtils.isBlank((CharSequence)keyword) ? this.applicationDAO.findAll() : this.applicationDAO.getApplications(keyword);
        return applications.stream().map(this::toDTO).toList();
    }

    public long countApplications() {
        return this.applicationDAO.count();
    }

    public List<UserApplication> getMandatoryAndFavoriteApplications(String username, Pageable pageable) {
        return this.applicationDAO.findFavoriteAndMandatoryApplications(username, pageable).map(this::toUserApplicationDTO).getContent();
    }

    private Application toDTO(ApplicationEntity applicationEntity) {
        FileInfo fileInfo;
        if (applicationEntity == null) {
            return null;
        }
        String imageFileName = null;
        long imageLastModified = DEFAULT_LAST_MODIFIED;
        if (applicationEntity.getImageFileId() != null && applicationEntity.getImageFileId() > 0L && (fileInfo = this.fileService.getFileInfo(applicationEntity.getImageFileId().longValue())) != null) {
            imageFileName = fileInfo.getName();
            if (fileInfo.getUpdatedDate() != null) {
                imageLastModified = fileInfo.getUpdatedDate().getTime();
            }
        }
        String[] permissions = StringUtils.split((String)applicationEntity.getPermissions(), (String)",");
        Application application = new Application(applicationEntity.getId(), applicationEntity.getTitle(), applicationEntity.getUrl(), applicationEntity.getHelpPageUrl(), applicationEntity.getImageFileId(), (Long)imageLastModified, null, imageFileName, applicationEntity.getDescription(), applicationEntity.isSystem(), applicationEntity.isActive(), applicationEntity.isMandatory(), applicationEntity.isMobile(), applicationEntity.isChangedManually(), permissions);
        application.setSystem(applicationEntity.isSystem());
        application.setHelpPageURL(applicationEntity.getHelpPageUrl());
        application.setMobile(applicationEntity.isMobile());
        return application;
    }

    private UserApplication toUserApplicationDTO(ApplicationEntity applicationEntity) {
        FileInfo fileInfo;
        if (applicationEntity == null) {
            return null;
        }
        String imageFileName = null;
        long imageLastModified = DEFAULT_LAST_MODIFIED;
        if (applicationEntity.getImageFileId() != null && applicationEntity.getImageFileId() > 0L && (fileInfo = this.fileService.getFileInfo(applicationEntity.getImageFileId().longValue())) != null) {
            imageFileName = fileInfo.getName();
            if (fileInfo.getUpdatedDate() != null) {
                imageLastModified = fileInfo.getUpdatedDate().getTime();
            }
        }
        String[] permissions = StringUtils.split((String)applicationEntity.getPermissions(), (String)",");
        UserApplication userApplication = new UserApplication(applicationEntity.getId(), applicationEntity.getTitle(), applicationEntity.getUrl(), applicationEntity.getHelpPageUrl(), applicationEntity.getImageFileId(), (Long)imageLastModified, null, imageFileName, applicationEntity.getDescription(), applicationEntity.isSystem(), applicationEntity.isActive(), applicationEntity.isMandatory(), applicationEntity.isMobile(), false, applicationEntity.isChangedManually(), permissions);
        userApplication.setSystem(applicationEntity.isSystem());
        userApplication.setHelpPageURL(applicationEntity.getHelpPageUrl());
        userApplication.setMobile(applicationEntity.isMobile());
        return userApplication;
    }

    private UserApplication toUserApplicationDTO(FavoriteApplicationEntity favoriteApplicationEntity) {
        FileInfo fileInfo;
        if (favoriteApplicationEntity == null) {
            return null;
        }
        ApplicationEntity applicationEntity = favoriteApplicationEntity.getApplication();
        String imageFileName = null;
        long imageLastModified = DEFAULT_LAST_MODIFIED;
        if (applicationEntity.getImageFileId() != null && applicationEntity.getImageFileId() > 0L && (fileInfo = this.fileService.getFileInfo(applicationEntity.getImageFileId().longValue())) != null) {
            imageFileName = fileInfo.getName();
            if (fileInfo.getUpdatedDate() != null) {
                imageLastModified = fileInfo.getUpdatedDate().getTime();
            }
        }
        String[] permissions = StringUtils.split((String)applicationEntity.getPermissions(), (String)",");
        UserApplication userApplication = new UserApplication(applicationEntity.getId(), applicationEntity.getTitle(), applicationEntity.getUrl(), applicationEntity.getHelpPageUrl(), applicationEntity.getImageFileId(), (Long)imageLastModified, null, imageFileName, applicationEntity.getDescription(), applicationEntity.isSystem(), applicationEntity.isActive(), applicationEntity.isMandatory(), applicationEntity.isMobile(), true, applicationEntity.isChangedManually(), permissions);
        userApplication.setOrder(favoriteApplicationEntity.getOrder());
        userApplication.setSystem(applicationEntity.isSystem());
        userApplication.setHelpPageURL(applicationEntity.getHelpPageUrl());
        userApplication.setMobile(applicationEntity.isMobile());
        return userApplication;
    }

    private ApplicationEntity toEntity(Application application) {
        if (application == null) {
            return null;
        }
        ApplicationEntity applicationEntity = new ApplicationEntity(application.getId(), application.getTitle(), application.getUrl(), application.getImageFileId(), application.getDescription(), application.isActive(), application.isMandatory(), StringUtils.join(application.getPermissions(), (String)","), application.isChangedManually());
        applicationEntity.setSystem(application.isSystem());
        applicationEntity.setHelpPageUrl(application.getHelpPageURL());
        applicationEntity.setMobile(application.isMobile());
        return applicationEntity;
    }

    private ApplicationImage updateAppImageFileItem(Long fileId, String fileName, String fileBody) {
        if (StringUtils.isBlank((CharSequence)fileName) || StringUtils.isBlank((CharSequence)fileBody)) {
            return null;
        }
        String fileContent = fileBody;
        if (fileBody.contains("base64,")) {
            String[] file = fileBody.split("base64,");
            fileContent = file[1];
        }
        byte[] bytesContent = fileContent.getBytes(Charset.defaultCharset().name());
        byte[] decodedBytes = Base64.getDecoder().decode(bytesContent);
        if (decodedBytes != null) {
            bytesContent = decodedBytes;
        }
        FileItem fileItem = new FileItem(fileId, fileName, "image/png", NAME_SPACE, (long)bytesContent.length, new Date(), null, false, (InputStream)new ByteArrayInputStream(bytesContent));
        fileItem = fileId != null && fileId > 0L ? this.fileService.updateFile(fileItem) : this.fileService.writeFile(fileItem);
        Long id = fileItem == null || fileItem.getFileInfo() == null ? null : fileItem.getFileInfo().getId();
        return new ApplicationImage(id, fileName, fileBody);
    }
}

