/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.storage;

import io.meeds.appcenter.constant.ApplicationType;
import io.meeds.appcenter.dao.ApplicationDAO;
import io.meeds.appcenter.dao.FavoriteApplicationDAO;
import io.meeds.appcenter.entity.ApplicationEntity;
import io.meeds.appcenter.entity.FavoriteApplicationEntity;
import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationForm;
import io.meeds.appcenter.model.exception.ApplicationNotFoundException;
import io.meeds.appcenter.storage.ApplicationCenterStorage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={ApplicationCenterStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class ApplicationCenterStorageTest {
    private static final String SHORTCUT = "G";
    private static final String HELP_PAGE_URL = "helpPageUrl";
    private static final String URL = "url";
    private static final String PERMISSIONS_2 = "permissions2";
    private static final String PERMISSIONS_1 = "permissions1";
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";
    private static final String TEST_USER = "testuser";
    private static final Long ID = 2L;
    @MockBean
    private FileService fileService;
    @MockBean
    private ApplicationDAO applicationDAO;
    @MockBean
    private FavoriteApplicationDAO favoriteApplicationDAO;
    @MockBean
    private UploadService uploadService;
    @Autowired
    private ApplicationCenterStorage applicationCenterStorage;

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.applicationDAO.save((Object)((ApplicationEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            ApplicationEntity entity = (ApplicationEntity)invocation.getArgument(0);
            if (entity.getId() == null) {
                entity.setId(ID);
            }
            Mockito.when((Object)this.applicationDAO.findById((Object)ID)).thenReturn(Optional.of(entity));
            return entity;
        });
        ((ApplicationDAO)Mockito.doAnswer(invocation -> {
            ApplicationEntity entity = (ApplicationEntity)invocation.getArgument(0);
            Mockito.when((Object)this.applicationDAO.findById((Object)entity.getId())).thenReturn(Optional.empty());
            return null;
        }).when((Object)this.applicationDAO)).delete((Object)((ApplicationEntity)ArgumentMatchers.any()));
    }

    @Test
    void createApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.createApplication(null));
        Application application = this.application(null);
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        Assertions.assertNotNull((Object)storedApplication);
        Assertions.assertNotNull((Object)storedApplication.getId());
        Assertions.assertTrue((storedApplication.getId() > 0L ? 1 : 0) != 0);
        storedApplication.setId(null);
        Assertions.assertEquals((Object)application, (Object)storedApplication);
    }

    @Test
    void createApplicationWithAttachment() {
        ApplicationForm application = new ApplicationForm(this.application(null));
        String uploadId = "uploadId";
        application.setImageUploadId(uploadId);
        UploadResource uploadResource = (UploadResource)Mockito.mock(UploadResource.class);
        Mockito.when((Object)this.uploadService.getUploadResource(uploadId)).thenReturn((Object)uploadResource);
        Mockito.when((Object)uploadResource.getStoreLocation()).thenReturn((Object)this.getClass().getResource("/applications.json").getFile());
        Application storedApplication = this.applicationCenterStorage.createApplication((Application)application);
        Assertions.assertNotNull((Object)storedApplication);
        ((FileService)Mockito.verify((Object)this.fileService)).writeFile((FileItem)ArgumentMatchers.any());
        long fileId = 55L;
        Mockito.when((Object)this.fileService.writeFile((FileItem)ArgumentMatchers.any())).thenAnswer(invocation -> {
            FileItem fileItem = (FileItem)invocation.getArgument(0);
            fileItem.setFileInfo(new FileInfo(Long.valueOf(fileId), null, null, null, 0L, null, null, null, false));
            return fileItem;
        });
        storedApplication = this.applicationCenterStorage.createApplication((Application)application);
        Assertions.assertEquals((long)fileId, (Long)storedApplication.getImageFileId());
    }

    @Test
    void updateApplication() {
        ApplicationEntity existingApplication = this.applicationEntity(ID);
        Mockito.when((Object)this.applicationDAO.findById((Object)ID)).thenReturn(Optional.of(existingApplication));
        Application application = this.application(ID);
        this.applicationCenterStorage.updateApplication(application);
        Application storedApplication = this.applicationCenterStorage.getApplication(ID.longValue());
        Assertions.assertNotNull((Object)storedApplication);
        Assertions.assertNotNull((Object)storedApplication.getId());
        Assertions.assertEquals((Object)application, (Object)storedApplication);
    }

    @Test
    void findSystemApplicationByUrl() {
        Application application = this.applicationCenterStorage.findSystemApplicationByUrl(URL);
        Assertions.assertNull((Object)application);
        ApplicationEntity existingApplication = this.applicationEntity(ID);
        Mockito.when((Object)this.applicationDAO.findBySystemIsTrueAndUrl(URL)).thenReturn(Collections.singletonList(existingApplication));
        Mockito.when((Object)this.applicationDAO.findById((Object)ID)).thenReturn(Optional.of(existingApplication));
        application = this.applicationCenterStorage.findSystemApplicationByUrl(URL);
        Assertions.assertNotNull((Object)application);
    }

    @Test
    void updateApplicationWithAttachment() {
        ApplicationEntity existingApplication = this.applicationEntity(ID);
        existingApplication.setMandatory(false);
        Mockito.when((Object)this.applicationDAO.findById((Object)ID)).thenReturn(Optional.of(existingApplication));
        ApplicationForm application = new ApplicationForm(this.application(ID));
        String uploadId = "uploadId";
        application.setImageUploadId(uploadId);
        UploadResource uploadResource = (UploadResource)Mockito.mock(UploadResource.class);
        Mockito.when((Object)this.uploadService.getUploadResource(uploadId)).thenReturn((Object)uploadResource);
        Mockito.when((Object)uploadResource.getStoreLocation()).thenReturn((Object)this.getClass().getResource("/applications.json").getFile());
        long fileId = 55L;
        Mockito.when((Object)this.fileService.updateFile((FileItem)ArgumentMatchers.any())).thenAnswer(invocation -> {
            FileItem fileItem = (FileItem)invocation.getArgument(0);
            fileItem.setFileInfo(new FileInfo(Long.valueOf(fileId), null, null, null, 0L, null, null, null, false));
            return fileItem;
        });
        this.applicationCenterStorage.updateApplication((Application)application);
        ((FileService)Mockito.verify((Object)this.fileService)).deleteFile(ArgumentMatchers.anyLong());
        ((FileService)Mockito.verify((Object)this.fileService)).updateFile((FileItem)ArgumentMatchers.any());
        ((ApplicationDAO)Mockito.verify((Object)this.applicationDAO)).save((Object)((ApplicationEntity)ArgumentMatchers.argThat(applicationEntity -> applicationEntity.getImageFileId() != null && applicationEntity.getImageFileId() == fileId)));
    }

    @Test
    void deleteApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.deleteApplication(0L));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterStorage.deleteApplication(5000L));
        Application application = this.application(null);
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        this.applicationCenterStorage.deleteApplication(storedApplication.getId().longValue());
        Assertions.assertNull((Object)this.applicationCenterStorage.getApplication(storedApplication.getId().longValue()));
    }

    @Test
    void getApplication() {
        Assertions.assertNull((Object)this.applicationCenterStorage.getApplication(50000L));
        Application application = this.application(null);
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        storedApplication = this.applicationCenterStorage.getApplication(storedApplication.getId().longValue());
        Assertions.assertNotNull((Object)storedApplication);
        Assertions.assertNotNull((Object)storedApplication.getId());
        Assertions.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
        Assertions.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
        Assertions.assertEquals((Long)application.getImageFileId(), (Long)storedApplication.getImageFileId());
        Assertions.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
        Assertions.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
        Assertions.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
        Assertions.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
    }

    @Test
    void addApplicationToUserFavorite() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.addApplicationToUserFavorite(0L, TEST_USER));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterStorage.addApplicationToUserFavorite(50000L, TEST_USER));
        Application application = this.application(ID);
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        this.applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), TEST_USER);
        ((FavoriteApplicationDAO)Mockito.verify((Object)this.favoriteApplicationDAO)).save((Object)((FavoriteApplicationEntity)ArgumentMatchers.argThat(fav -> fav.getFavorite() != null && fav.getFavorite() != false && fav.getUserName().equals(TEST_USER) && fav.getApplication().getId().equals(ID))));
    }

    @Test
    void addApplicationToUserFavoriteWhenExisting() {
        Application application = this.application(ID);
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        Mockito.when((Object)this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(ID, TEST_USER)).thenReturn((Object)new FavoriteApplicationEntity(ID, null, TEST_USER, Long.valueOf(5L), Boolean.valueOf(false)));
        this.applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), TEST_USER);
        ((FavoriteApplicationDAO)Mockito.verify((Object)this.favoriteApplicationDAO)).save((Object)((FavoriteApplicationEntity)ArgumentMatchers.argThat(fav -> fav.getFavorite() != null && fav.getFavorite() != false && fav.getUserName().equals(TEST_USER))));
    }

    @Test
    void updateFavoriteApplicationOrder() {
        FavoriteApplicationEntity favoriteApplicationEntity = (FavoriteApplicationEntity)Mockito.mock(FavoriteApplicationEntity.class);
        Mockito.when((Object)this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(ID, TEST_USER)).thenReturn((Object)favoriteApplicationEntity);
        this.applicationCenterStorage.updateFavoriteApplicationOrder(ID.longValue(), TEST_USER, Long.valueOf(1L));
        ((FavoriteApplicationDAO)Mockito.verify((Object)this.favoriteApplicationDAO)).save((Object)favoriteApplicationEntity);
        this.applicationCenterStorage.updateFavoriteApplicationOrder(ID.longValue(), TEST_USER, Long.valueOf(1L));
        ((FavoriteApplicationDAO)Mockito.verify((Object)this.favoriteApplicationDAO, (VerificationMode)Mockito.times((int)2))).save((Object)favoriteApplicationEntity);
    }

    @Test
    void deleteApplicationFavorite() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.deleteApplicationFavorite(Long.valueOf(0L), TEST_USER));
        this.applicationCenterStorage.deleteApplicationFavorite(Long.valueOf(50000L), TEST_USER);
        Application application = this.application(null);
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        this.applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), TEST_USER);
        this.applicationCenterStorage.deleteApplicationFavorite(storedApplication.getId(), TEST_USER);
    }

    @Test
    void getApplications() {
        List applications = this.applicationCenterStorage.getApplications(null);
        Assertions.assertNotNull((Object)applications);
        Assertions.assertEquals((int)0, (int)applications.size());
        applications = this.applicationCenterStorage.getApplications(TITLE);
        Assertions.assertNotNull((Object)applications);
        Assertions.assertEquals((int)0, (int)applications.size());
        Mockito.when((Object)this.applicationDAO.getApplicationIds()).thenReturn(Arrays.asList(3L, 2L, 5L));
        Mockito.when((Object)this.applicationDAO.getApplicationIds(TITLE)).thenReturn(Arrays.asList(3L, 5L));
        Mockito.when((Object)this.applicationDAO.getApplicationIds(URL)).thenReturn(Collections.singletonList(3L));
        Mockito.when((Object)this.applicationDAO.findById((Object)2L)).thenReturn(Optional.of(this.applicationEntity(2L)));
        Mockito.when((Object)this.applicationDAO.findById((Object)3L)).thenReturn(Optional.of(this.applicationEntity(3L)));
        Mockito.when((Object)this.applicationDAO.findById((Object)5L)).thenReturn(Optional.of(this.applicationEntity(5L)));
        applications = this.applicationCenterStorage.getApplications(null);
        Assertions.assertNotNull((Object)applications);
        Assertions.assertEquals((int)3, (int)applications.size());
        applications = this.applicationCenterStorage.getApplications(TITLE);
        Assertions.assertNotNull((Object)applications);
        Assertions.assertEquals((int)2, (int)applications.size());
        applications = this.applicationCenterStorage.getApplications(URL);
        Assertions.assertNotNull((Object)applications);
        Assertions.assertEquals((int)1, (int)applications.size());
    }

    @Test
    void countApplications() {
        Assertions.assertEquals((long)0L, (long)this.applicationCenterStorage.countApplications());
        Mockito.when((Object)this.applicationDAO.count()).thenReturn((Object)1L);
        Assertions.assertEquals((long)1L, (long)this.applicationCenterStorage.countApplications());
    }

    @Test
    void getFavoriteAppByUserNameAndAppId() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.isFavoriteApplication(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.isFavoriteApplication(null, TEST_USER));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.isFavoriteApplication(Long.valueOf(0L), TEST_USER));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.isFavoriteApplication(Long.valueOf(1L), null));
        FavoriteApplicationEntity favoriteApplicationEntity = (FavoriteApplicationEntity)Mockito.mock(FavoriteApplicationEntity.class);
        Mockito.when((Object)this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(ID, TEST_USER)).thenReturn((Object)favoriteApplicationEntity);
        Assertions.assertFalse((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
        Mockito.when((Object)favoriteApplicationEntity.getFavorite()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
    }

    @Test
    void isFavoriteApplication() {
        Assertions.assertFalse((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
        ApplicationEntity applicationEntity = (ApplicationEntity)Mockito.mock(ApplicationEntity.class);
        Mockito.lenient().when((Object)this.applicationDAO.findById((Object)ID)).thenReturn(Optional.of(applicationEntity));
        Assertions.assertFalse((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
        Mockito.lenient().when((Object)applicationEntity.isDefault()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
    }

    @Test
    void isFavoriteApplicationWhenAppIsDefaultButNotFavorite() {
        Assertions.assertFalse((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
        ApplicationEntity applicationEntity = (ApplicationEntity)Mockito.mock(ApplicationEntity.class);
        Mockito.when((Object)this.applicationDAO.findById((Object)ID)).thenReturn(Optional.of(applicationEntity));
        Assertions.assertFalse((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
        Mockito.when((Object)applicationEntity.isDefault()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
        FavoriteApplicationEntity favoriteApplicationEntity = (FavoriteApplicationEntity)Mockito.mock(FavoriteApplicationEntity.class);
        Mockito.when((Object)this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(ID, TEST_USER)).thenReturn((Object)favoriteApplicationEntity);
        Assertions.assertFalse((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
        Mockito.when((Object)favoriteApplicationEntity.getFavorite()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
    }

    @Test
    void countFavorites() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.countFavorites(null));
        Assertions.assertEquals((long)0L, (long)this.applicationCenterStorage.countFavorites(TEST_USER));
        Mockito.when((Object)this.favoriteApplicationDAO.countFavoritesForUser(TEST_USER)).thenReturn((Object)1L);
        Assertions.assertEquals((long)1L, (long)this.applicationCenterStorage.countFavorites(TEST_USER));
    }

    @Test
    void getSystemApplications() {
        Mockito.when((Object)this.applicationDAO.getSystemApplicationIds()).thenReturn(Collections.singletonList(ID));
        ApplicationEntity applicationEntity = (ApplicationEntity)Mockito.mock(ApplicationEntity.class);
        Mockito.when((Object)this.applicationDAO.findById((Object)ID)).thenReturn(Optional.of(applicationEntity));
        Assertions.assertEquals((int)1, (int)this.applicationCenterStorage.getSystemApplications().size());
    }

    private ApplicationEntity applicationEntity(Long id) {
        return new ApplicationEntity(id, "title1", "description1", ApplicationType.LINK, URL, true, "icon", "helpPageUrl1", Long.valueOf(6L), true, false, false, false, false, true, SHORTCUT, Collections.singletonList(PERMISSIONS_2), false, null, null);
    }

    private Application application(Long id) {
        return new Application(id, TITLE, URL, true, HELP_PAGE_URL, DESCRIPTION, SHORTCUT, ApplicationType.LINK, false, true, false, true, false, true, Collections.singletonList(PERMISSIONS_1), null, null, "icon", null, null, false);
    }
}

