/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.storage;

import io.meeds.appcenter.dao.ApplicationDAO;
import io.meeds.appcenter.dao.FavoriteApplicationDAO;
import io.meeds.appcenter.entity.ApplicationEntity;
import io.meeds.appcenter.entity.FavoriteApplicationEntity;
import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationForm;
import io.meeds.appcenter.model.UserApplication;
import io.meeds.appcenter.model.exception.ApplicationNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ApplicationCenterStorage {
    private static final String APPLICATION_NOT_FOUND_MESSAGE = "Application with id %s doesn't exist";
    private static final String APPLICATION_ID_IS_MANDATORY_MESSAGE = "applicationId is mandatory";
    private static final String USERNAME_IS_MANDATORY_MESSAGE = "username is mandatory";
    public static final String NAME_SPACE = "appCenter";
    public static final Long DEFAULT_LAST_MODIFIED = System.currentTimeMillis();
    @Autowired
    private FileService fileService;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private FavoriteApplicationDAO favoriteApplicationDAO;
    @Autowired(required=false)
    private CodecInitializer codecInitializer;

    public Application createApplication(Application application) {
        ApplicationForm applicationForm;
        if (application == null) {
            throw new IllegalArgumentException("application is mandatory");
        }
        ApplicationEntity applicationEntity = this.toEntity(application);
        applicationEntity.setId(null);
        if (application instanceof ApplicationForm && StringUtils.isNotBlank((CharSequence)(applicationForm = (ApplicationForm)application).getImageUploadId())) {
            Long imageFileId = this.saveImageFileItem(null, applicationForm.getImageUploadId());
            applicationEntity.setImageFileId(imageFileId);
        }
        applicationEntity = (ApplicationEntity)this.applicationDAO.save(applicationEntity);
        return this.getApplication(applicationEntity.getId());
    }

    @CacheEvict(cacheNames={"app-center.application"}, key="#p0.getId()")
    public void updateApplication(Application application) {
        ApplicationForm applicationForm;
        Long applicationId = application.getId();
        ApplicationEntity storedApplicationEntity = (ApplicationEntity)this.applicationDAO.findById(applicationId).orElseThrow();
        application.setSystem(storedApplicationEntity.isSystem());
        Long oldImageFileId = storedApplicationEntity.getImageFileId();
        boolean imageRemoved = (application.getImageFileId() == null || application.getImageFileId() == 0L) && oldImageFileId != null && oldImageFileId > 0L;
        application.setImageFileId(oldImageFileId);
        if (imageRemoved) {
            application.setImageFileId(null);
            this.fileService.deleteFile(oldImageFileId.longValue());
        }
        if (application instanceof ApplicationForm && StringUtils.isNotBlank((CharSequence)(applicationForm = (ApplicationForm)application).getImageUploadId())) {
            Long imageFileId = this.saveImageFileItem(oldImageFileId, applicationForm.getImageUploadId());
            application.setImageFileId(imageFileId);
        }
        if (application.isMandatory() && !storedApplicationEntity.isMandatory()) {
            this.favoriteApplicationDAO.removeAllFavoritesOfApplication(application.getId());
        }
        ApplicationEntity applicationEntity = this.toEntity(application);
        this.applicationDAO.save(applicationEntity);
    }

    @CacheEvict(cacheNames={"app-center.application"}, key="#p0")
    public void deleteApplication(long applicationId) throws ApplicationNotFoundException {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        ApplicationEntity applicationEntity = this.applicationDAO.findById(applicationId).orElse(null);
        if (applicationEntity == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        this.applicationDAO.delete(applicationEntity);
    }

    @Cacheable(value={"app-center.application"})
    public Application getApplication(long applicationId) {
        ApplicationEntity applicationEntity = this.applicationDAO.findById(applicationId).orElse(null);
        return this.toDTO(applicationEntity);
    }

    public Application findSystemApplicationByUrl(String url) {
        List<ApplicationEntity> list = this.applicationDAO.findBySystemIsTrueAndUrl(url);
        ApplicationEntity applicationEntity = CollectionUtils.isEmpty(list) ? null : list.get(0);
        return applicationEntity == null ? null : this.getApplication(applicationEntity.getId());
    }

    public FavoriteApplicationEntity addApplicationToUserFavorite(long applicationId, String username) throws ApplicationNotFoundException {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        FavoriteApplicationEntity applicationFavorite = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username);
        if (applicationFavorite == null) {
            ApplicationEntity applicationEntity = this.applicationDAO.findById(applicationId).orElse(null);
            if (applicationEntity == null) {
                throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
            }
            applicationFavorite = (FavoriteApplicationEntity)this.favoriteApplicationDAO.save(new FavoriteApplicationEntity(null, applicationEntity, username, 0L, true));
        } else if (applicationFavorite.getFavorite() == null || !applicationFavorite.getFavorite().booleanValue()) {
            applicationFavorite.setFavorite(true);
            applicationFavorite = (FavoriteApplicationEntity)this.favoriteApplicationDAO.save(applicationFavorite);
        }
        return applicationFavorite;
    }

    public void updateFavoriteApplicationOrder(long applicationId, String username, Long order) throws ApplicationNotFoundException {
        FavoriteApplicationEntity entity = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username);
        if (entity == null) {
            entity = this.addApplicationToUserFavorite(applicationId, username);
        }
        entity.setOrder(order);
        this.favoriteApplicationDAO.save(entity);
    }

    public void deleteApplicationFavorite(Long applicationId, String username) {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        FavoriteApplicationEntity applicationFavorite = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username);
        if (applicationFavorite == null) {
            ApplicationEntity applicationEntity = this.applicationDAO.findById(applicationId).orElse(null);
            if (applicationEntity != null) {
                this.favoriteApplicationDAO.save(new FavoriteApplicationEntity(null, applicationEntity, username, 0L, false));
            }
        } else {
            applicationFavorite.setFavorite(false);
            this.favoriteApplicationDAO.save(applicationFavorite);
        }
    }

    public List<Application> getSystemApplications() {
        return this.applicationDAO.getSystemApplicationIds().stream().map(this::getApplication).filter(Objects::nonNull).toList();
    }

    public boolean isFavoriteApplication(Long applicationId, String username) {
        if (applicationId == null || applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        FavoriteApplicationEntity applicationFavorite = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username);
        if (applicationFavorite != null) {
            return applicationFavorite.getFavorite();
        }
        ApplicationEntity applicationEntity = this.applicationDAO.findById(applicationId).orElse(null);
        return applicationEntity != null && applicationEntity.isDefault();
    }

    public long countFavorites(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        return this.favoriteApplicationDAO.countFavoritesForUser(username);
    }

    public Long getApplicationImageLastUpdated(long fileId) {
        FileItem fileItem = this.fileService.getFile(fileId);
        if (fileItem != null && fileItem.getFileInfo().getUpdatedDate() != null) {
            return fileItem.getFileInfo().getUpdatedDate().getTime();
        }
        return null;
    }

    public InputStream getApplicationImageInputStream(long fileId) {
        FileItem fileItem = this.fileService.getFile(fileId);
        if (fileItem != null && fileItem.getAsByte() != null) {
            return new ByteArrayInputStream(fileItem.getAsByte());
        }
        return null;
    }

    public List<Application> getApplications(String keyword) {
        List<Long> applicationIds = StringUtils.isBlank((CharSequence)keyword) ? this.applicationDAO.getApplicationIds() : this.applicationDAO.getApplicationIds(keyword);
        return applicationIds.stream().map(this::getApplication).filter(Objects::nonNull).toList();
    }

    public long countApplications() {
        return this.applicationDAO.count();
    }

    public List<UserApplication> getMandatoryAndFavoriteApplications(String username, Pageable pageable) {
        return this.applicationDAO.findFavoriteAndMandatoryApplications(username, pageable).map(this::toUserApplicationDTO).getContent();
    }

    private Long saveImageFileItem(Long imageFileId, String uploadId) {
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        byte[] bytesContent = IOUtil.getFileContentAsBytes((String)uploadResource.getStoreLocation());
        FileItem fileItem = new FileItem(imageFileId, "appCenterIllustration", "image/png", NAME_SPACE, (long)bytesContent.length, new Date(), null, false, (InputStream)new ByteArrayInputStream(bytesContent));
        fileItem = imageFileId != null && imageFileId > 0L ? this.fileService.updateFile(fileItem) : this.fileService.writeFile(fileItem);
        return fileItem == null || fileItem.getFileInfo() == null ? null : fileItem.getFileInfo().getId();
    }

    private Application toDTO(ApplicationEntity applicationEntity) {
        FileInfo fileInfo;
        if (applicationEntity == null) {
            return null;
        }
        long imageLastModified = DEFAULT_LAST_MODIFIED;
        if (applicationEntity.getImageFileId() != null && applicationEntity.getImageFileId() > 0L && (fileInfo = this.fileService.getFileInfo(applicationEntity.getImageFileId().longValue())) != null && fileInfo.getUpdatedDate() != null) {
            imageLastModified = fileInfo.getUpdatedDate().getTime();
        }
        return new Application(applicationEntity.getId(), applicationEntity.getTitle(), applicationEntity.getUrl(), applicationEntity.isSameTab(), applicationEntity.getHelpPageUrl(), applicationEntity.getDescription(), applicationEntity.getShortcut(), applicationEntity.getType(), applicationEntity.isActive(), applicationEntity.isMandatory(), applicationEntity.isDefault(), applicationEntity.isMobile(), applicationEntity.isSystem(), applicationEntity.isPwa(), applicationEntity.getPermissions(), null, applicationEntity.getImageFileId(), applicationEntity.getIcon(), this.getImageUrl(applicationEntity.getImageFileId(), applicationEntity.getId(), imageLastModified), applicationEntity.getOrder(), applicationEntity.isChangedManually());
    }

    private UserApplication toUserApplicationDTO(Long applicationId) {
        Application application = this.getApplication(applicationId);
        return application == null ? null : new UserApplication(application);
    }

    private UserApplication toUserApplicationDTO(FavoriteApplicationEntity favoriteApplicationEntity) {
        if (favoriteApplicationEntity == null || favoriteApplicationEntity.getApplication() == null) {
            return null;
        }
        UserApplication userApplication = this.toUserApplicationDTO(favoriteApplicationEntity.getApplication().getId());
        if (userApplication == null) {
            return null;
        }
        if (favoriteApplicationEntity.getOrder() != null) {
            userApplication.setOrder(favoriteApplicationEntity.getOrder());
        }
        userApplication.setFavorite(favoriteApplicationEntity.getFavorite() == null ? favoriteApplicationEntity.getApplication().isDefault() : favoriteApplicationEntity.getFavorite().booleanValue());
        return userApplication;
    }

    private ApplicationEntity toEntity(Application application) {
        if (application == null) {
            return null;
        }
        return new ApplicationEntity(application.getId(), application.getTitle(), application.getDescription(), application.getType(), application.getUrl(), application.isSameTab(), application.getIcon(), application.getHelpPageURL(), application.getImageFileId(), application.isActive(), application.isDefault(), application.isMandatory(), application.isMobile(), application.isSystem(), application.isPwa(), application.getShortcut(), application.getPermissions(), application.isChangedManually(), application.getOrder(), null);
    }

    private String getImageUrl(Long imageFileId, Long id, long imageLastModified) {
        if (imageFileId == null || imageFileId == 0L) {
            return null;
        }
        return String.format("/app-center/rest/applications/illustration/%s?v=%s&r=%s", id, imageLastModified, this.generateToken(id, imageLastModified));
    }

    private String generateToken(Long id, long imageLastModified) {
        if (this.codecInitializer == null) {
            return "";
        }
        return URLEncoder.encode(LinkProvider.generateAttachmentToken((String)"appcenter", (String)String.valueOf(id), (String)"icon", (String)String.valueOf(imageLastModified)), StandardCharsets.UTF_8);
    }
}

