/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.service;

import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationList;
import io.meeds.appcenter.model.ApplicationOrder;
import io.meeds.appcenter.model.UserApplication;
import io.meeds.appcenter.model.exception.ApplicationNotFoundException;
import io.meeds.appcenter.storage.ApplicationCenterStorage;
import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.service.CategoryLinkService;
import io.meeds.social.translation.service.TranslationService;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.thumbnail.ImageThumbnailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ApplicationCenterService {
    private static final String APPLICATION_IS_MANDATORY_MESSAGE = "application is mandatory";
    public static final String ANY_PERMISSION = "any";
    public static final String DEFAULT_USERS_GROUP = "/platform/users";
    public static final String DEFAULT_USERS_PERMISSION = "*:/platform/users";
    public static final String MAX_FAVORITE_APPS = "maxFavoriteApps";
    public static final String DEFAULT_APP_IMAGE_NAME = "defaultAppImageName";
    public static final String DEFAULT_APP_IMAGE_BODY = "defaultAppImageBody";
    public static final int DEFAULT_LIMIT = 10;
    public static final Context APP_CENTER_CONTEXT = Context.GLOBAL.id("APP_CENTER");
    public static final Scope APP_CENTER_SCOPE = Scope.APPLICATION.id("APP_CENTER");
    private static final String USERNAME_IS_MANDATORY_MESSAGE = "username is mandatory";
    private static final String APPLICATION_ID_IS_MANDATORY_MESSAGE = "applicationId is mandatory";
    private static final String USER_NOT_ALLOWED_MESSAGE = "User %s is not allowed to save application : %s";
    private static final String APPLICATION_NOT_FOUND_MESSAGE = "Application with id %s doesn't exist";
    @Autowired
    private UserACL userAcl;
    @Autowired
    private ApplicationCenterStorage appCenterStorage;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private FileService fileService;
    @Autowired
    private ImageThumbnailService imageThumbnailService;
    @Autowired
    private PortalContainer portalContainer;
    private CategoryLinkService categoryLinkService;
    @Value(value="${appcenter.administrators.expression:*:/platform/administrators}")
    private String defaultAdministratorPermission = null;
    @Value(value="${appcenter.favorites.count:12}")
    private long defaultMaxFavoriteApps;

    public Application createApplication(Application application, String username) throws IllegalAccessException {
        if (!this.canEdit(username)) {
            throw new IllegalAccessException(String.format(USER_NOT_ALLOWED_MESSAGE, username, application.getTitle()));
        }
        return this.createApplication(application);
    }

    public Application createApplication(Application application) {
        if (application == null) {
            throw new IllegalArgumentException(APPLICATION_IS_MANDATORY_MESSAGE);
        }
        return this.appCenterStorage.createApplication(application);
    }

    public Application getApplication(long applicationId) {
        return this.appCenterStorage.getApplication(applicationId);
    }

    public Application findSystemApplicationByUrl(String url) {
        return this.appCenterStorage.findSystemApplicationByUrl(url);
    }

    public void updateApplication(Application application, String username) throws IllegalAccessException, ApplicationNotFoundException {
        if (application == null) {
            throw new IllegalArgumentException(APPLICATION_IS_MANDATORY_MESSAGE);
        }
        Long applicationId = application.getId();
        if (applicationId == null) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        Application storedApplication = this.appCenterStorage.getApplication(applicationId);
        if (storedApplication == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        if (StringUtils.isBlank((CharSequence)username) || !this.canEdit(username)) {
            throw new IllegalAccessException(String.format(USER_NOT_ALLOWED_MESSAGE, username, application.getTitle()));
        }
        this.updateApplication(application);
    }

    public void updateApplication(Application application) {
        this.appCenterStorage.updateApplication(application);
    }

    public void deleteApplication(Long applicationId, String username) throws ApplicationNotFoundException, IllegalAccessException {
        if (applicationId == null) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        Application storedApplication = this.appCenterStorage.getApplication(applicationId);
        if (storedApplication == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        if (!this.canEdit(username)) {
            throw new IllegalAccessException(String.format(USER_NOT_ALLOWED_MESSAGE, username, storedApplication.getTitle()));
        }
        if (storedApplication.isSystem()) {
            throw new IllegalAccessException(String.format("Application with id %s is a system application, thus it can't be deleted", applicationId));
        }
        this.deleteApplication(applicationId);
    }

    public void deleteApplication(Long applicationId) throws ApplicationNotFoundException {
        Application application = this.appCenterStorage.getApplication(applicationId);
        if (application != null) {
            if (CollectionUtils.isNotEmpty(application.getCategoryIds())) {
                application.getCategoryIds().forEach(id -> this.getCategoryLinkService().unlink(id.longValue(), new CategoryObject("appCenter", String.valueOf(applicationId), 0L)));
            }
            this.appCenterStorage.deleteApplication(applicationId);
        }
    }

    public void addFavoriteApplication(long applicationId, String username) throws ApplicationNotFoundException, IllegalAccessException {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        if (applicationId <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        Application application = this.appCenterStorage.getApplication(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        if (!this.canAccess(application, username)) {
            throw new IllegalAccessException(String.format("User %s doesn't have enough permissions to delete application '%s'", username, application.getTitle()));
        }
        this.appCenterStorage.addApplicationToUserFavorite(applicationId, username);
    }

    public void deleteFavoriteApplication(Long applicationId, String username) {
        if (applicationId == null) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        this.appCenterStorage.deleteApplicationFavorite(applicationId, username);
    }

    public ApplicationList getApplications(int offset, int limit, String keyword) {
        return this.getApplications(offset, limit, keyword, null);
    }

    public ApplicationList getApplications(int offset, int limit, String keyword, Locale locale) {
        ApplicationList applicationList = new ApplicationList();
        List<Application> applications = this.appCenterStorage.getApplications(keyword);
        int totalApplictions = applications.size();
        if (limit <= 0) {
            limit = applications.size();
        }
        applications = applications.stream().skip(offset).limit(limit).toList();
        this.setApplicationLabels(applications, locale);
        this.setApplicationCategories(applications);
        applicationList.setApplications(applications);
        applicationList.setSize(totalApplictions);
        applicationList.setOffset(offset);
        applicationList.setLimit(limit);
        return applicationList;
    }

    public ApplicationList getActiveApplications(int offset, int limit, String keyword, String username) {
        return this.getActiveApplications(offset, limit, keyword, null, username);
    }

    public ApplicationList getActiveApplications(int offset, int limit, String keyword, Locale locale, String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        ApplicationList resultApplicationsList = new ApplicationList();
        List<Application> applications = this.getActiveApplications(keyword, username).stream().toList();
        int totalApplication = applications.size();
        if (limit > 0) {
            applications = applications.stream().skip(offset).limit(limit).toList();
        }
        applications = applications.stream().map(app -> {
            UserApplication applicationFavorite = new UserApplication((Application)app);
            applicationFavorite.setFavorite(this.appCenterStorage.isFavoriteApplication(applicationFavorite.getId(), username));
            return applicationFavorite;
        }).toList();
        this.setApplicationLabels(applications, locale);
        this.setApplicationCategories(applications);
        resultApplicationsList.setApplications(applications);
        resultApplicationsList.setOffset(offset);
        resultApplicationsList.setLimit(limit);
        resultApplicationsList.setSize(totalApplication);
        return resultApplicationsList;
    }

    public void updateFavoriteApplicationOrder(ApplicationOrder applicationOrder, String userName) throws ApplicationNotFoundException {
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        if (applicationOrder.getId() <= 0L) {
            throw new IllegalArgumentException(APPLICATION_ID_IS_MANDATORY_MESSAGE);
        }
        Application application = this.appCenterStorage.getApplication(applicationOrder.getId());
        if (application == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationOrder.getId()));
        }
        if (!application.isMandatory()) {
            this.appCenterStorage.addApplicationToUserFavorite(applicationOrder.getId(), userName);
        }
        this.appCenterStorage.updateFavoriteApplicationOrder(applicationOrder.getId(), userName, applicationOrder.getOrder());
    }

    public Long getApplicationImageLastUpdated(long applicationId) throws ApplicationNotFoundException {
        Application application = this.appCenterStorage.getApplication(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        if (application.getImageFileId() != null) {
            return this.appCenterStorage.getApplicationImageLastUpdated(application.getImageFileId());
        }
        return null;
    }

    public InputStream getApplicationImageInputStream(long applicationId) throws ApplicationNotFoundException {
        return this.getApplicationImageInputStream(applicationId, null);
    }

    public InputStream getApplicationImageInputStream(long applicationId, String dimensions) throws ApplicationNotFoundException {
        Application application = this.appCenterStorage.getApplication(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException(String.format(APPLICATION_NOT_FOUND_MESSAGE, applicationId));
        }
        if (application.getImageFileId() != null) {
            if (StringUtils.contains((CharSequence)dimensions, (CharSequence)"x")) {
                FileItem fileItem = this.fileService.getFile(application.getImageFileId().longValue());
                Integer[] dimensionParts = (Integer[])Arrays.stream(dimensions.split("x")).map(Integer::parseInt).toArray(Integer[]::new);
                FileItem thumbnailFileItem = this.imageThumbnailService.getOrCreateThumbnail(fileItem, dimensionParts[0].intValue(), dimensionParts[1].intValue());
                return this.appCenterStorage.getApplicationImageInputStream(thumbnailFileItem.getFileInfo().getId());
            }
            return this.appCenterStorage.getApplicationImageInputStream(application.getImageFileId());
        }
        return null;
    }

    public List<Application> getSystemApplications() {
        return this.appCenterStorage.getSystemApplications();
    }

    public List<Long> getCategoryIds() {
        return this.getCategoryLinkService().getLinkedIds("appCenter");
    }

    public ApplicationList getMandatoryAndFavoriteApplications(Pageable pageable, String username, Locale locale) {
        List<Application> applications = this.appCenterStorage.getMandatoryAndFavoriteApplications(username, pageable).stream().filter(app -> this.canAccess((Application)app, username)).collect(Collectors.toList());
        int appCount = applications.size();
        ApplicationList applicationList = new ApplicationList();
        this.setApplicationLabels(applications, locale);
        this.setApplicationCategories(applications);
        return applicationList.setApplications(applications).setLimit(appCount).setSize(appCount).setOffset(0L);
    }

    public List<String> getApplicationShortcuts(String username) {
        return this.getActiveApplications(null, username).stream().map(Application::getShortcut).filter(StringUtils::isNotBlank).toList();
    }

    public boolean canAccess(Application application, String username) {
        return this.canAccess(application.getPermissions(), username);
    }

    public boolean canEdit(String username) {
        return StringUtils.isBlank((CharSequence)username) || this.userAcl.isAdministrator(this.getUserIdentity(username));
    }

    private boolean canAccess(List<String> storedPermissions, String username) {
        Identity identity = this.getUserIdentity(username);
        if (CollectionUtils.isEmpty(storedPermissions)) {
            return identity != null && this.userAcl.hasPermission(identity, DEFAULT_USERS_PERMISSION);
        }
        return storedPermissions.stream().anyMatch(exp -> this.userAcl.hasPermission(identity, exp));
    }

    private Identity getUserIdentity(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return new Identity(IdentityConstants.ANONIM);
        }
        return this.userAcl.getUserIdentity(username);
    }

    private List<Application> getActiveApplications(String keyword, String username) {
        return this.appCenterStorage.getApplications(keyword).stream().filter(app -> this.canAccess((Application)app, username)).filter(Application::isActive).toList();
    }

    private void setApplicationLabels(List<Application> applications, Locale locale) {
        if (locale != null) {
            applications.forEach(application -> this.setApplicationLabels((Application)application, locale));
        }
    }

    private void setApplicationCategories(List<Application> applications) {
        applications.forEach(this::setApplicationCategories);
    }

    private void setApplicationCategories(Application application) {
        List categoryIds = this.getCategoryLinkService().getLinkedIds(new CategoryObject("appCenter", String.valueOf(application.getId()), 0L));
        application.setCategoryIds(categoryIds);
    }

    private void setApplicationLabels(Application application, Locale locale) {
        String description;
        String title = this.translationService.getTranslationLabelOrDefault("appCenter", application.getId().longValue(), "title", locale);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            application.setTitle(title);
        }
        if (StringUtils.isNotBlank((CharSequence)(description = this.translationService.getTranslationLabelOrDefault("appCenter", application.getId().longValue(), "description", locale)))) {
            application.setDescription(description);
        }
    }

    private CategoryLinkService getCategoryLinkService() {
        if (this.categoryLinkService == null) {
            this.categoryLinkService = (CategoryLinkService)this.portalContainer.getComponentInstanceOfType(CategoryLinkService.class);
        }
        return this.categoryLinkService;
    }
}

