/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.plugin;

import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.plugin.ApplicationCategoryPlugin;
import io.meeds.appcenter.service.ApplicationCenterService;
import org.exoplatform.container.PortalContainer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={ApplicationCategoryPlugin.class})
@ExtendWith(value={MockitoExtension.class})
public class ApplicationCategoryPluginTest {
    private static final String TEST_USER = "testuser";
    private static final String APP_ID = "15";
    @MockBean
    private ApplicationCenterService applicationCenterService;
    @MockBean
    private PortalContainer portalContainer;
    @Autowired
    private ApplicationCategoryPlugin categoryPlugin;

    @BeforeEach
    void setup() {
        Mockito.lenient().when((Object)((ApplicationCenterService)this.portalContainer.getComponentInstanceOfType(ApplicationCenterService.class))).thenReturn((Object)this.applicationCenterService);
    }

    @Test
    void getObjectType() {
        Assertions.assertEquals((Object)"appCenter", (Object)this.categoryPlugin.getType());
    }

    @Test
    void canAccessWhenAdmin() {
        Assertions.assertFalse((boolean)this.categoryPlugin.canAccess(APP_ID, TEST_USER));
        Application application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)this.applicationCenterService.getApplication(Long.parseLong(APP_ID))).thenReturn((Object)application);
        Assertions.assertFalse((boolean)this.categoryPlugin.canAccess(APP_ID, TEST_USER));
        Mockito.when((Object)this.applicationCenterService.canEdit(TEST_USER)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.categoryPlugin.canAccess(APP_ID, TEST_USER));
    }

    @Test
    void canAccessWhenActive() {
        Assertions.assertFalse((boolean)this.categoryPlugin.canAccess(APP_ID, TEST_USER));
        Application application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)this.applicationCenterService.getApplication(Long.parseLong(APP_ID))).thenReturn((Object)application);
        Assertions.assertFalse((boolean)this.categoryPlugin.canAccess(APP_ID, TEST_USER));
        Mockito.when((Object)this.applicationCenterService.canAccess(application, TEST_USER)).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.categoryPlugin.canAccess(APP_ID, TEST_USER));
        Mockito.when((Object)application.isActive()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.categoryPlugin.canAccess(APP_ID, TEST_USER));
    }

    @Test
    void canEdit() {
        Assertions.assertFalse((boolean)this.categoryPlugin.canEdit(APP_ID, TEST_USER));
        Mockito.when((Object)this.applicationCenterService.canEdit(TEST_USER)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.categoryPlugin.canEdit(APP_ID, TEST_USER));
    }
}

