/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.storage;

import io.meeds.billing.dao.HubBillingSettingsDAO;
import io.meeds.billing.entity.HubBillingSettingsEntity;
import io.meeds.billing.model.HubBillingSettings;
import io.meeds.billing.utils.Utils;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Component;

@Component
public class HubBillingSettingsStorage {
    public static final String HUB_SETTING_CACHE_NAME = "billing.HubBillingSettings";
    public static final String METER_LIST_CACHE_NAME = "billing.MeteredHubBillingSettingList";
    @Autowired
    private HubBillingSettingsDAO hubBillingSettingsDAO;

    @Caching(evict={@CacheEvict(value={"billing.HubBillingSettings"}, allEntries=true), @CacheEvict(value={"billing.MeteredHubBillingSettingList"}, allEntries=true)})
    public HubBillingSettings save(HubBillingSettings hubBillingSettings) {
        HubBillingSettingsEntity hubBillingSettingsEntity = Utils.toEntity(hubBillingSettings);
        hubBillingSettingsEntity = (HubBillingSettingsEntity)this.hubBillingSettingsDAO.save(hubBillingSettingsEntity);
        return Utils.fromEntity(hubBillingSettingsEntity);
    }

    @Cacheable(value={"billing.HubBillingSettings"}, key="#p0")
    public HubBillingSettings getHubBillingSettingsBySpaceId(long spaceId) throws ObjectNotFoundException {
        HubBillingSettingsEntity hubBillingSettingsEntity = this.hubBillingSettingsDAO.findBySpaceId(spaceId);
        if (hubBillingSettingsEntity != null) {
            return Utils.fromEntity(hubBillingSettingsEntity);
        }
        throw new ObjectNotFoundException("No settings found for hub: " + spaceId);
    }

    @Caching(evict={@CacheEvict(value={"billing.HubBillingSettings"}, allEntries=true), @CacheEvict(value={"billing.MeteredHubBillingSettingList"}, allEntries=true)})
    public void updateSubscriptionStatus(Long billingHubId, String newSubscriptionStatus) {
        HubBillingSettingsEntity hubBillingSettingsEntity = this.hubBillingSettingsDAO.findById(billingHubId).orElse(null);
        if (hubBillingSettingsEntity == null) {
            throw new IllegalArgumentException("No settings found for hub: " + billingHubId);
        }
        hubBillingSettingsEntity.setSubscriptionStatus(newSubscriptionStatus);
        this.hubBillingSettingsDAO.save(hubBillingSettingsEntity);
    }

    @Cacheable(value={"billing.MeteredHubBillingSettingList"}, key="'meteredList'")
    public List<HubBillingSettings> getMeteredHubBillingSettingList() {
        return this.hubBillingSettingsDAO.findByPlan_MeterIdIsNotNull().stream().map(Utils::fromEntity).toList();
    }

    @Cacheable(value={"billing.HubBillingSettings"}, key="#p0")
    public HubBillingSettings getHubBillingSettingBySubscriptionId(String subscriptionId) throws ObjectNotFoundException {
        HubBillingSettingsEntity hubBillingSettingsEntity = this.hubBillingSettingsDAO.findBySubscriptionId(subscriptionId);
        if (hubBillingSettingsEntity != null) {
            return Utils.fromEntity(hubBillingSettingsEntity);
        }
        throw new ObjectNotFoundException("No settings found for hub with subscription id: " + subscriptionId);
    }
}

