/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.FileLink;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.FileLinkCreateParams;
import com.stripe.param.FileLinkListParams;
import com.stripe.param.FileLinkRetrieveParams;
import com.stripe.param.FileLinkUpdateParams;
import java.lang.reflect.Type;

public final class FileLinkService
extends ApiService {
    public FileLinkService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<FileLink> list(FileLinkListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<FileLink> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<FileLink> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<FileLink> list(FileLinkListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/file_links";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<FileLink>>(){}.getType());
    }

    public FileLink create(FileLinkCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public FileLink create(FileLinkCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/file_links";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FileLink)this.request(request, (Type)((Object)FileLink.class));
    }

    public FileLink retrieve(String link, FileLinkRetrieveParams params) throws StripeException {
        return this.retrieve(link, params, null);
    }

    public FileLink retrieve(String link, RequestOptions options) throws StripeException {
        return this.retrieve(link, null, options);
    }

    public FileLink retrieve(String link) throws StripeException {
        return this.retrieve(link, null, null);
    }

    public FileLink retrieve(String link, FileLinkRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/file_links/%s", ApiResource.urlEncodeId(link));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (FileLink)this.request(request, (Type)((Object)FileLink.class));
    }

    public FileLink update(String link, FileLinkUpdateParams params) throws StripeException {
        return this.update(link, params, null);
    }

    public FileLink update(String link, RequestOptions options) throws StripeException {
        return this.update(link, null, options);
    }

    public FileLink update(String link) throws StripeException {
        return this.update(link, null, null);
    }

    public FileLink update(String link, FileLinkUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/file_links/%s", ApiResource.urlEncodeId(link));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FileLink)this.request(request, (Type)((Object)FileLink.class));
    }
}

