/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.listener;

import com.stripe.model.Price;
import com.stripe.model.Subscription;
import io.meeds.billing.model.HubBilling;
import io.meeds.billing.service.BillingService;
import io.meeds.billing.service.HubSettingService;
import io.meeds.billing.utils.Utils;
import jakarta.annotation.PostConstruct;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillingSpaceListener
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(BillingSpaceListener.class);
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private HubSettingService hubSettingService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private HubBilling hubBilling;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private BillingService billingService;

    @PostConstruct
    public void init() {
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)this);
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        if (!this.isBillableSpaceTemplate(space)) {
            return;
        }
        String username = (String)event.getSource();
        try {
            Identity identity = this.identityManager.getOrCreateUserIdentity(username);
            String priceId = Utils.getTemplatePriceId(space.getTemplateId());
            if (priceId == null) {
                LOG.error("Missing Price ID for space '{}'. The Price ID must not be null or empty.", new Object[]{space.getDisplayName()});
                return;
            }
            Price price = this.billingService.getPriceById(priceId);
            String customerId = this.billingService.createCustomer(space, identity);
            Subscription subscription = this.billingService.subscribe(space, customerId, price.getId());
            this.hubSettingService.createSettings(space, subscription, identity);
        }
        catch (Exception e) {
            LOG.error("Error while creating billing setup for space '{}' with user {} : {}", new Object[]{space.getDisplayName(), username, e.getMessage(), e});
        }
    }

    private boolean isBillableSpaceTemplate(Space space) {
        return this.isBillingEnabled() && this.hubBilling.getSpaceTemplateIds().contains(space.getTemplateId());
    }

    private boolean isBillingEnabled() {
        return this.billingService.isEnabled();
    }
}

