/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.tax;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.tax.Registration;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.tax.RegistrationCreateParams;
import com.stripe.param.tax.RegistrationListParams;
import com.stripe.param.tax.RegistrationRetrieveParams;
import com.stripe.param.tax.RegistrationUpdateParams;
import java.lang.reflect.Type;

public final class RegistrationService
extends ApiService {
    public RegistrationService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Registration> list(RegistrationListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Registration> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Registration> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Registration> list(RegistrationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/registrations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Registration>>(){}.getType());
    }

    public Registration create(RegistrationCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Registration create(RegistrationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/registrations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Registration)this.request(request, (Type)((Object)Registration.class));
    }

    public Registration retrieve(String id, RegistrationRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Registration retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Registration retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Registration retrieve(String id, RegistrationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/registrations/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Registration)this.request(request, (Type)((Object)Registration.class));
    }

    public Registration update(String id, RegistrationUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public Registration update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public Registration update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public Registration update(String id, RegistrationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/registrations/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Registration)this.request(request, (Type)((Object)Registration.class));
    }
}

