/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.storage;

import io.meeds.billing.dao.HubBillingPlanDAO;
import io.meeds.billing.entity.HubBillingPlanEntity;
import io.meeds.billing.model.HubBillingPlan;
import io.meeds.billing.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Component;

@Component
public class HubBillingPlanStorage {
    private static final String CACHE_NAME = "billing.HubBillingPlan";
    @Autowired
    private HubBillingPlanDAO hubBillingPlanDAO;

    @Cacheable(value={"billing.HubBillingPlan"})
    public HubBillingPlan findByPlanId(String planId) {
        return Utils.fromEntity(this.hubBillingPlanDAO.findByPlanId(planId));
    }

    @Caching(evict={@CacheEvict(value={"billing.HubBillingPlan"}, allEntries=true), @CacheEvict(value={"billing.HubBillingSettings"}, allEntries=true), @CacheEvict(value={"billing.MeteredHubBillingSettingList"}, allEntries=true)})
    public HubBillingPlan saveHubBillingPlan(HubBillingPlan hubBillingPlan) {
        HubBillingPlanEntity hubBillingPlanEntity = Utils.toEntity(hubBillingPlan);
        hubBillingPlanEntity = (HubBillingPlanEntity)this.hubBillingPlanDAO.save(hubBillingPlanEntity);
        return Utils.fromEntity(hubBillingPlanEntity);
    }
}

