/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.listener;

import io.meeds.billing.model.HubBilling;
import io.meeds.billing.service.BillingService;
import jakarta.annotation.PostConstruct;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFF)
public class SpaceSiteCreatedListener
implements ListenerBase<SiteKey, SiteKey> {
    private static final Log LOG = ExoLogger.getLogger(SpaceSiteCreatedListener.class);
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private BillingService billingService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private HubBilling hubBilling;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("site.template.instantiated", (ListenerBase)this);
    }

    public void onEvent(Event<SiteKey, SiteKey> event) {
        boolean isBillableSpace;
        SiteKey siteKey = (SiteKey)event.getData();
        if (!siteKey.getName().startsWith("/spaces/")) {
            return;
        }
        Space space = this.spaceService.getSpaceByGroupId(siteKey.getName());
        if (space == null) {
            return;
        }
        boolean bl = isBillableSpace = this.hubBilling.isEnabled() && this.hubBilling.getSpaceTemplateIds().contains(space.getTemplateId());
        if (isBillableSpace) {
            this.updateSpaceLayout(siteKey);
        }
    }

    private void updateSpaceLayout(SiteKey siteKey) {
        try {
            this.billingService.updateBillableSpaceLayout(siteKey);
        }
        catch (Exception e) {
            LOG.error("Error while adding portlet 'HubSubscriptionRestriction' to space site layout with id '{}'", new Object[]{siteKey, e});
        }
    }
}

