/*
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.billing.entity;

import jakarta.persistence.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Entity(name = "HubBillingSettings")
@Table(name = "BILLING_HUB_SETTINGS")
@Data
public class HubBillingSettingsEntity implements Serializable {

  @Id
  @SequenceGenerator(name = "SEQ_BILLING_HUB_SETTINGS_ID", sequenceName = "SEQ_BILLING_HUB_SETTINGS_ID", allocationSize = 1)
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "SEQ_BILLING_HUB_SETTINGS_ID")
  @Column(name = "ID", nullable = false)
  private Long id;

  @Column(name = "SPACE_ID", nullable = false)
  private Long spaceId;

  @Column(name = "USER_IDENTITY_ID", nullable = false)
  private Long userIdentityId;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "CREATED_DATE", nullable = false)
  private Date createdDate = new Date();

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "UPDATED_DATE", nullable = false)
  private Date updatedDate = new Date();

  @Column(name = "CUSTOMER_ID")
  private String customerId;

  @Column(name = "SUBSCRIPTION_ID")
  private String subscriptionId;

  @Column(name = "SUBSCRIPTION_STATUS")
  private String subscriptionStatus;

  @Column(name = "SUBSCRIPTION_PREVIOUS_STATUS")
  private String subscriptionPreviousStatus;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "SUBSCRIPTION_CURRENT_PERIOD_END")
  private Date   subscriptionCurrentPeriodEnd;

  @ManyToOne
  @JoinColumn(name = "PLAN_ID")
  @EqualsAndHashCode.Exclude
  @ToString.Exclude
  private HubBillingPlanEntity plan;

  @Column(name = "SUBSCRIPTION_QUANTITY")
  private Long subscriptionQuantity;
}
