/*
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.billing.storage;

import io.meeds.billing.dao.HubBillingPlanDAO;
import io.meeds.billing.entity.HubBillingPlanEntity;
import io.meeds.billing.model.HubBillingPlan;
import io.meeds.billing.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Component;

import static io.meeds.billing.storage.HubBillingSettingsStorage.HUB_SETTING_CACHE_NAME;
import static io.meeds.billing.storage.HubBillingSettingsStorage.METER_LIST_CACHE_NAME;
import static io.meeds.billing.storage.HubBillingSettingsStorage.TIERED_LIST_CACHE_NAME;

@Component
public class HubBillingPlanStorage {

  private static final String CACHE_NAME = "billing.HubBillingPlan";

  @Autowired
  private HubBillingPlanDAO   hubBillingPlanDAO;

  @Cacheable(value = CACHE_NAME)
  public HubBillingPlan findByPlanId(String planId) {
    return Utils.fromEntity(hubBillingPlanDAO.findByPlanId(planId));
  }

  @Caching(evict = {
          @CacheEvict(value = CACHE_NAME, allEntries = true),
          @CacheEvict(value = HUB_SETTING_CACHE_NAME, allEntries = true),
          @CacheEvict(value = METER_LIST_CACHE_NAME,  allEntries = true),
          @CacheEvict(value = TIERED_LIST_CACHE_NAME, allEntries = true)
  })
  public HubBillingPlan saveHubBillingPlan(HubBillingPlan hubBillingPlan) {
    HubBillingPlanEntity hubBillingPlanEntity = Utils.toEntity(hubBillingPlan);
    hubBillingPlanEntity = hubBillingPlanDAO.save(hubBillingPlanEntity);
    return Utils.fromEntity(hubBillingPlanEntity);
  }

}
