/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billig.listener;

import io.meeds.billing.listener.SpaceSiteCreatedListener;
import io.meeds.billing.model.HubBilling;
import io.meeds.billing.service.BillingService;
import java.util.Collections;
import java.util.List;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

@SpringBootTest(classes={SpaceSiteCreatedListener.class})
@ExtendWith(value={MockitoExtension.class})
public class SpaceSiteCreatedListenerTest {
    @MockitoBean
    private HubBilling hubBilling;
    @MockitoBean
    private SpaceService spaceService;
    @MockitoBean
    private ListenerService listenerService;
    @MockBean
    private BillingService billingService;
    @Autowired
    private SpaceSiteCreatedListener spaceSiteCreatedListener;

    @BeforeEach
    void setUp() {
        this.spaceSiteCreatedListener.init();
    }

    @Test
    public void onEvent() throws Exception {
        Space space = new Space();
        space.setGroupId("/spaces/test");
        space.setTemplateId(1L);
        SiteKey siteKey = new SiteKey(SiteType.GROUP, space.getGroupId());
        Mockito.when((Object)this.hubBilling.isEnabled()).thenReturn((Object)true);
        List<Long> templateIds = Collections.singletonList(1L);
        Mockito.when((Object)this.hubBilling.getSpaceTemplateIds()).thenReturn(templateIds);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(siteKey.getName())).thenReturn((Object)space);
        ((BillingService)Mockito.doNothing().when((Object)this.billingService)).updateBillableSpaceLayout(siteKey);
        Event event = new Event("site.template.instantiated", (Object)"", (Object)siteKey);
        this.spaceSiteCreatedListener.onEvent(event);
        ((BillingService)Mockito.verify((Object)this.billingService)).updateBillableSpaceLayout(siteKey);
    }
}

