/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billig.service;

import com.stripe.model.Subscription;
import io.meeds.billing.model.HubBilling;
import io.meeds.billing.model.HubBillingSettings;
import io.meeds.billing.service.BillingService;
import io.meeds.billing.service.HubBillingPlanService;
import io.meeds.billing.service.HubSettingService;
import io.meeds.billing.storage.HubBillingSettingsStorage;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

@SpringBootTest(classes={HubSettingService.class})
@ExtendWith(value={MockitoExtension.class})
public class HubSettingServiceTest {
    @MockitoBean
    private HubBilling hubBilling;
    @MockitoBean
    private HubBillingSettingsStorage hubBillingSettingsStorage;
    @MockitoBean
    private BillingService billingService;
    @MockitoBean
    private HubBillingPlanService hubBillingPlanService;
    @MockitoBean
    private SpaceService spaceService;
    @Autowired
    private HubSettingService hubSettingService;

    @Test
    public void testCreateSettingsHubBillingSettings() throws ObjectAlreadyExistsException {
        Space space = (Space)Mockito.mock(Space.class);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        String customerId = "customer_1";
        String subscriptionId = "subscription_1";
        String subscriptionStatus = "subscription_status_1";
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)space.getSpaceId()).thenReturn((Object)1L);
        Subscription subscription = (Subscription)Mockito.mock(Subscription.class);
        Mockito.when((Object)subscription.getId()).thenReturn((Object)subscriptionId);
        Mockito.when((Object)subscription.getStatus()).thenReturn((Object)subscriptionStatus);
        Mockito.when((Object)subscription.getCustomer()).thenReturn((Object)customerId);
        this.hubSettingService.createSettings(space, subscription, identity);
        ((HubBillingSettingsStorage)Mockito.verify((Object)this.hubBillingSettingsStorage, (VerificationMode)Mockito.times((int)1))).save((HubBillingSettings)ArgumentMatchers.argThat(hubBillingSettings -> customerId.equals(hubBillingSettings.getCustomerId()) && subscriptionId.equals(hubBillingSettings.getSubscriptionId()) && subscriptionStatus.equals(hubBillingSettings.getSubscriptionStatus())));
    }

    @Test
    public void shouldThrowObjectNotFoundExceptionIfSpaceNotFound() {
        long spaceId = 1L;
        Mockito.when((Object)this.spaceService.getSpaceById(spaceId)).thenReturn(null);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.hubSettingService.getSettingsBySpaceId(Long.valueOf(spaceId), "user"));
    }

    @Test
    public void shouldThrowIllegalAccessExceptionIfUserNotAuthorized() {
        long spaceId = 1L;
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceById(spaceId)).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.isManager((Space)ArgumentMatchers.any(Space.class), ArgumentMatchers.anyString())).thenReturn((Object)false);
        Assert.assertThrows(IllegalAccessException.class, () -> this.hubSettingService.getSettingsBySpaceId(Long.valueOf(spaceId), "user"));
    }

    @Test
    public void shouldReturnHubBillingSettings() throws ObjectNotFoundException, IllegalAccessException {
        long spaceId = 1L;
        String currentUser = "user";
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceById(spaceId)).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.canManageSpace(space, currentUser)).thenReturn((Object)true);
        Mockito.when((Object)this.hubBillingSettingsStorage.getHubBillingSettingsBySpaceId(spaceId)).thenReturn((Object)new HubBillingSettings());
        Assertions.assertNotNull((Object)this.hubSettingService.getSettingsBySpaceId(Long.valueOf(spaceId), currentUser));
    }
}

