/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.service;

import com.stripe.model.Subscription;
import io.meeds.billing.model.HubBillingSettings;
import io.meeds.billing.service.HubBillingPlanService;
import io.meeds.billing.storage.HubBillingSettingsStorage;
import io.meeds.billing.utils.Utils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HubSettingService {
    @Autowired
    private HubBillingSettingsStorage hubBillingSettingsStorage;
    @Autowired
    private HubBillingPlanService hubBillingPlanService;
    @Autowired
    private SpaceService spaceService;

    public void createSettings(Space space, Subscription subscription, Identity identity) throws ObjectAlreadyExistsException {
        HubBillingSettings hubBillingSettings = this.getSettingsBySpaceId(space.getId());
        if (hubBillingSettings != null) {
            throw new ObjectAlreadyExistsException((Object)("Hub billing settings already exists for space " + space.getDisplayName()));
        }
        hubBillingSettings = new HubBillingSettings();
        hubBillingSettings.setSpaceId(space.getSpaceId());
        hubBillingSettings.setUserIdentityId(Long.parseLong(identity.getId()));
        hubBillingSettings.setCreatedDate(new Date());
        hubBillingSettings.setUpdatedDate(new Date());
        hubBillingSettings.setCustomerId(subscription.getCustomer());
        hubBillingSettings.setSubscriptionId(subscription.getId());
        hubBillingSettings.setSubscriptionStatus(subscription.getStatus());
        hubBillingSettings.setSubscriptionPreviousStatus(subscription.getStatus());
        hubBillingSettings.setSubscriptionCurrentPeriodEnd(Utils.getCurrentPeriodEndDate(subscription));
        hubBillingSettings.setHubBillingPlan(this.hubBillingPlanService.getOrCreateHubBillingPlan(subscription));
        this.hubBillingSettingsStorage.save(hubBillingSettings);
    }

    public void updateSettings(HubBillingSettings hubBillingSettings) {
        this.hubBillingSettingsStorage.save(hubBillingSettings);
    }

    public HubBillingSettings getSettingsBySpaceId(Long spaceId, String authenticatedUser) throws ObjectNotFoundException, IllegalAccessException {
        Space space = this.spaceService.getSpaceById(spaceId.longValue());
        if (space == null) {
            throw new ObjectNotFoundException("Space not found for Space Id: " + spaceId);
        }
        if (!this.spaceService.canManageSpace(space, authenticatedUser)) {
            throw new IllegalAccessException("User" + authenticatedUser + " is not allowed to mange space " + spaceId);
        }
        return this.hubBillingSettingsStorage.getHubBillingSettingsBySpaceId(spaceId);
    }

    public HubBillingSettings getSettingsBySubscriptionId(String subscriptionId) throws ObjectNotFoundException {
        return this.hubBillingSettingsStorage.getHubBillingSettingBySubscriptionId(subscriptionId);
    }

    public HubBillingSettings getSettingsBySpaceId(String spaceId) {
        try {
            return this.hubBillingSettingsStorage.getHubBillingSettingsBySpaceId(Long.parseLong(spaceId));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void updateSubscriptionStatus(Long billingHubId, String newSubscriptionStatus) {
        this.hubBillingSettingsStorage.updateSubscriptionStatus(billingHubId, newSubscriptionStatus);
    }

    public void updateHuBillingSetting(HubBillingSettings hubBillingSettings, Subscription subscription, Map<String, Object> previousAttributes) {
        boolean keepTrialing;
        String previousStatus = Optional.ofNullable(previousAttributes).map(attributes -> (String)attributes.get("status")).orElse(null);
        String newStatus = subscription.getStatus();
        Date currentPeriodEnd = Utils.getCurrentPeriodEndDate(subscription);
        boolean bl = keepTrialing = Utils.SubscriptionStatus.TRIALING.name().equalsIgnoreCase(previousStatus) && Utils.SubscriptionStatus.ACTIVE.name().equalsIgnoreCase(newStatus);
        if (keepTrialing) {
            newStatus = Utils.SubscriptionStatus.TRIALING.name();
            currentPeriodEnd = hubBillingSettings.getSubscriptionCurrentPeriodEnd();
        }
        hubBillingSettings.setSubscriptionPreviousStatus(hubBillingSettings.getSubscriptionStatus());
        hubBillingSettings.setSubscriptionStatus(newStatus);
        hubBillingSettings.setSubscriptionCurrentPeriodEnd(currentPeriodEnd);
        hubBillingSettings.setHubBillingPlan(this.hubBillingPlanService.getOrCreateHubBillingPlan(subscription));
        this.hubBillingSettingsStorage.save(hubBillingSettings);
    }

    public List<HubBillingSettings> getMeteredHubBillingSettingList() {
        return this.hubBillingSettingsStorage.getMeteredHubBillingSettingList();
    }
}

