/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.scheduling.task;

import io.meeds.billing.model.HubBillingSettings;
import io.meeds.billing.service.BillingService;
import io.meeds.billing.service.HubSettingService;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class HubBillingReportJob {
    private static final Log LOG = ExoLogger.getLogger(HubBillingReportJob.class);
    @Autowired
    private BillingService billingService;
    @Autowired
    private HubSettingService hubSettingService;

    @Scheduled(cron="${meeds.billing.hubBillingReport.job.cron:0 0 0 * * *}")
    public void reportMembersCount() {
        if (!this.billingService.isEnabled()) {
            return;
        }
        List<HubBillingSettings> hubBillingSettingsList = this.hubSettingService.getMeteredHubBillingSettingList();
        if (hubBillingSettingsList.isEmpty()) {
            return;
        }
        hubBillingSettingsList.forEach(hubBillingSettings -> {
            try {
                this.billingService.reportMembersCount((HubBillingSettings)hubBillingSettings);
            }
            catch (Exception exception) {
                LOG.error("Error when reporting members count for space with id {}, {}", new Object[]{hubBillingSettings.getSpaceId(), exception.getMessage()});
            }
        });
    }
}

