/*
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.billing.config;

import io.meeds.billing.model.HubBilling;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
public class BillingConfiguration {


  @Value("${meeds.billing.enabled:false}")
  private boolean          billingEnabled;

  @Value("${meeds.billing.secretKey:}")
  private String           secretKey;

  @Value("${meeds.billing.webhook.secretKey:}")
  private String            webhookSecretKey;

  @Value("#{'${meeds.billing.spaceTemplateIds:}'.split(',')}")
  private List<Long>       spaceTemplateIds;


  @Bean
  public HubBilling hubBillingProperties() {
    return new HubBilling(billingEnabled, secretKey, webhookSecretKey, spaceTemplateIds);
  }

}
