/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.service;

import com.stripe.model.Plan;
import com.stripe.model.Subscription;
import io.meeds.billing.model.HubBillingPlan;
import io.meeds.billing.storage.HubBillingPlanStorage;
import io.meeds.billing.utils.Utils;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HubBillingPlanService {
    @Autowired
    private HubBillingPlanStorage hubBillingPlanStorage;

    public HubBillingPlan getOrCreateHubBillingPlan(Subscription subscription) {
        Plan plan = Utils.getPlanFromSubscription(subscription);
        HubBillingPlan hubBillingPlan = this.hubBillingPlanStorage.findByPlanId(plan.getId());
        if (hubBillingPlan != null) {
            return hubBillingPlan;
        }
        hubBillingPlan = new HubBillingPlan();
        hubBillingPlan.setPlanId(plan.getId());
        hubBillingPlan.setMeterId(plan.getMeter());
        hubBillingPlan.setProductId(plan.getProduct());
        hubBillingPlan.setBillingScheme(plan.getBillingScheme());
        hubBillingPlan.setTiersMode(plan.getTiersMode());
        long maxOfUsers = Optional.ofNullable(plan.getMetadata()).filter(MapUtils::isNotEmpty).map(metadata -> (String)metadata.get("maxOfUsers")).map(Long::parseLong).orElse(0L);
        hubBillingPlan.setMaxUsers(maxOfUsers);
        hubBillingPlan = this.hubBillingPlanStorage.saveHubBillingPlan(hubBillingPlan);
        return hubBillingPlan;
    }

    public HubBillingPlan getHubBillingPlanByPlanId(String planId) {
        return this.hubBillingPlanStorage.findByPlanId(planId);
    }

    public HubBillingPlan saveHubBillingPlan(HubBillingPlan hubBillingPlan) {
        return this.hubBillingPlanStorage.saveHubBillingPlan(hubBillingPlan);
    }
}

