/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd.transport;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.ProtocolNotSuppException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.loadbalancer.LoadBalancer;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;
import org.exoplatform.ws.frameworks.cometd.transport.DelegateMessage;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class ContinuationServiceRemoteDelegate
implements ContinuationServiceDelegate {
    private static final Log LOG = ExoLogger.getLogger(ContinuationServiceRemoteDelegate.class);
    private final LoadBalancer loadBalancer;
    private final String restContextName;

    public ContinuationServiceRemoteDelegate(LoadBalancer loadBalancer, ExoContainerContext context) {
        this.loadBalancer = loadBalancer;
        this.restContextName = context.getRestContextName();
    }

    private String getBaseCometdURL(String exoID) {
        return this.loadBalancer.connection(exoID);
    }

    @Override
    public Boolean isSubscribed(String exoID, String channel) {
        try {
            String baseURICometdServer = this.getBaseCometdURL(exoID);
            URL url = new URL(baseURICometdServer + "/" + this.restContextName + "/issubscribed/" + exoID + "/" + channel + "/");
            HTTPConnection connection = new HTTPConnection(url);
            HTTPResponse response = connection.Get(url.getFile());
            String bol = new String(response.getData());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Check user " + exoID + " subscription to channel " + channel));
            }
            return new Boolean(bol);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Malformed URL: ", (Throwable)e);
        }
        catch (ProtocolNotSuppException e) {
            LOG.error((Object)"Protocol is not supported: ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IO exception: ", (Throwable)e);
        }
        catch (ModuleException e) {
            LOG.error((Object)"error when getting response: ", (Throwable)e);
        }
        return null;
    }

    @Override
    public void sendMessage(String exoID, String channel, String message, String msgId) {
        try {
            String baseURICometdServer = this.getBaseCometdURL(exoID);
            URL url = new URL(baseURICometdServer + "/" + this.restContextName + "/continuation/sendprivatemessage/");
            HTTPConnection connection = new HTTPConnection(url);
            DelegateMessage transportData = new DelegateMessage(channel, exoID, message, msgId);
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            JsonValue json = generatorImpl.createJsonObject((Object)transportData);
            NVPair[] pairs = new NVPair[]{new NVPair("Content-Type", "application/json")};
            HTTPResponse response = connection.Post(url.getFile(), json.toString(), pairs);
            if (response.getStatusCode() == 200) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Send private message : " + message + " to client " + exoID + " by cahnnel " + channel + " success"));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Send private message : " + message + " to client " + exoID + " by cahnnel " + channel + " fail!"));
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Malformed URL: ", (Throwable)e);
        }
        catch (ProtocolNotSuppException e) {
            LOG.error((Object)"Protocol is not supported: ", (Throwable)e);
        }
        catch (JsonException e) {
            LOG.error((Object)"error when create JSON object: ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IO exception: ", (Throwable)e);
        }
        catch (ModuleException e) {
            LOG.error((Object)"error when getting response: ", (Throwable)e);
        }
    }

    @Override
    public void sendBroadcastMessage(String channel, String message, String msgId) {
        try {
            List<String> us = this.getCometdURLsByChannel(channel);
            if (us != null) {
                for (String u : us) {
                    URL url = new URL(u + "/" + this.restContextName + "/continuation/sendbroadcastmessage/");
                    DelegateMessage transportData = new DelegateMessage(channel, message, msgId);
                    JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                    JsonValue json = generatorImpl.createJsonObject((Object)transportData);
                    HTTPConnection connection = new HTTPConnection(url);
                    NVPair[] pairs = new NVPair[]{new NVPair("Content-Type", "application/json")};
                    HTTPResponse response = connection.Post(url.getFile(), json.toString(), pairs);
                    if (response.getStatusCode() == 200) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Send public message : " + message + " to channel " + channel + " success"));
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Send public message : " + message + " to channel " + channel + " fail!"));
                }
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Malformed URL: ", (Throwable)e);
        }
        catch (ProtocolNotSuppException e) {
            LOG.error((Object)"Protocol is not supported: ", (Throwable)e);
        }
        catch (JsonException e) {
            LOG.error((Object)"error when create JSON object: ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IO exception: ", (Throwable)e);
        }
        catch (ModuleException e) {
            LOG.error((Object)"error when getting response: ", (Throwable)e);
        }
    }

    private List<String> getCometdURLsByChannel(String channel) {
        try {
            List<String> curls = this.loadBalancer.getAliveNodesURL();
            ArrayList<String> urls = new ArrayList<String>();
            for (String curl : curls) {
                String u = new String(curl + "/" + this.restContextName + "/continuation/haschannel?channel=" + channel);
                URL url = new URL(u);
                HTTPConnection connection = new HTTPConnection(url);
                HTTPResponse response = connection.Get(url.getFile());
                boolean b = Boolean.parseBoolean(new String(response.getData()));
                if (!b) continue;
                urls.add(curl);
            }
            return urls;
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Malformed URL: ", (Throwable)e);
        }
        catch (ProtocolNotSuppException e) {
            LOG.error((Object)"Protocol is not supported: ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IO exception: ", (Throwable)e);
        }
        catch (ModuleException e) {
            LOG.error((Object)"error when getting response: ", (Throwable)e);
        }
        return null;
    }
}

