/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.notifications.email.dao;

import java.io.Serializable;
import java.util.Calendar;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailDigestEntity;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailNotifEntity;
import org.exoplatform.commons.notification.job.NotificationJob;
import org.exoplatform.commons.persistence.impl.EntityManagerHolder;
import org.exoplatform.jpa.CommonsDAOJPAImplTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MailDigestDAOTest
extends CommonsDAOJPAImplTest {
    private JPAMailNotificationStorage notificationDataStorage;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mailDigestDAO.deleteAll();
        this.notificationDataStorage = (JPAMailNotificationStorage)this.getService(JPAMailNotificationStorage.class);
    }

    @Override
    @After
    public void tearDown() {
        this.mailDigestDAO.deleteAll();
    }

    @Test
    public void testIsDigestSent() throws Exception {
        MailNotifEntity mailNotifEntity1 = new MailNotifEntity();
        mailNotifEntity1.setType("type");
        mailNotifEntity1.setCreationDate(Calendar.getInstance());
        mailNotifEntity1.setOrder(0);
        MailNotifEntity mailNotifEntity2 = new MailNotifEntity();
        mailNotifEntity2.setType("type2");
        mailNotifEntity2.setCreationDate(Calendar.getInstance());
        mailNotifEntity2.setOrder(1);
        mailNotifEntity1 = (MailNotifEntity)this.mailNotifDAO.create((Object)mailNotifEntity1);
        mailNotifEntity2 = (MailNotifEntity)this.mailNotifDAO.create((Object)mailNotifEntity2);
        this.mailDigestDAO.create((Object)new MailDigestEntity().setNotification(mailNotifEntity1).setType("daily"));
        this.mailDigestDAO.create((Object)new MailDigestEntity().setNotification(mailNotifEntity1).setType("weekly"));
        this.mailDigestDAO.create((Object)new MailDigestEntity().setNotification(mailNotifEntity2).setType("daily"));
        this.mailDigestDAO.create((Object)new MailDigestEntity().setNotification(mailNotifEntity2).setType("weekly"));
        EntityManagerHolder.get().clear();
        mailNotifEntity1 = (MailNotifEntity)this.mailNotifDAO.find((Serializable)Long.valueOf(mailNotifEntity1.getId()));
        mailNotifEntity2 = (MailNotifEntity)this.mailNotifDAO.find((Serializable)Long.valueOf(mailNotifEntity2.getId()));
        MailDigestDAOTest.assertNotNull((Object)mailNotifEntity1);
        MailDigestDAOTest.assertNotNull((Object)mailNotifEntity2);
        MailDigestDAOTest.assertEquals((int)2, (int)mailNotifEntity1.getDigests().size());
        MailDigestDAOTest.assertEquals((int)2, (int)mailNotifEntity2.getDigests().size());
        NotificationContext context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)true);
        this.notificationDataStorage.removeMessageAfterSent(context);
        EntityManagerHolder.get().clear();
        mailNotifEntity1 = (MailNotifEntity)this.mailNotifDAO.find((Serializable)Long.valueOf(mailNotifEntity1.getId()));
        mailNotifEntity2 = (MailNotifEntity)this.mailNotifDAO.find((Serializable)Long.valueOf(mailNotifEntity2.getId()));
        MailDigestDAOTest.assertNotNull((Object)mailNotifEntity1);
        MailDigestDAOTest.assertNotNull((Object)mailNotifEntity2);
        MailDigestDAOTest.assertEquals((int)1, (int)mailNotifEntity1.getDigests().size());
        MailDigestDAOTest.assertEquals((int)1, (int)mailNotifEntity2.getDigests().size());
        context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_WEEKLY, (Object)true);
        this.notificationDataStorage.removeMessageAfterSent(context);
        EntityManagerHolder.get().clear();
        mailNotifEntity1 = (MailNotifEntity)this.mailNotifDAO.find((Serializable)Long.valueOf(mailNotifEntity1.getId()));
        mailNotifEntity2 = (MailNotifEntity)this.mailNotifDAO.find((Serializable)Long.valueOf(mailNotifEntity2.getId()));
        MailDigestDAOTest.assertNull((Object)mailNotifEntity1);
        MailDigestDAOTest.assertNull((Object)mailNotifEntity2);
    }

    @Test
    public void testDeleteAll() throws Exception {
        MailNotifEntity mailNotifEntity1 = new MailNotifEntity();
        mailNotifEntity1.setType("type");
        mailNotifEntity1.setCreationDate(Calendar.getInstance());
        mailNotifEntity1.setOrder(0);
        MailNotifEntity mailNotifEntity2 = new MailNotifEntity();
        mailNotifEntity2.setType("type2");
        mailNotifEntity2.setCreationDate(Calendar.getInstance());
        mailNotifEntity2.setOrder(1);
        mailNotifEntity1 = (MailNotifEntity)this.mailNotifDAO.create((Object)mailNotifEntity1);
        mailNotifEntity2 = (MailNotifEntity)this.mailNotifDAO.create((Object)mailNotifEntity2);
        this.mailDigestDAO.create((Object)new MailDigestEntity().setNotification(mailNotifEntity1).setType("daily"));
        this.mailDigestDAO.create((Object)new MailDigestEntity().setNotification(mailNotifEntity1).setType("weekly"));
        this.mailDigestDAO.create((Object)new MailDigestEntity().setNotification(mailNotifEntity2).setType("daily"));
        this.mailDigestDAO.create((Object)new MailDigestEntity().setNotification(mailNotifEntity2).setType("weekly"));
        this.notificationDataStorage.deleteAllDigests();
        MailDigestDAOTest.assertEquals((long)0L, (long)this.mailDigestDAO.count());
    }
}

