/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.lifecycle;

import java.util.Calendar;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.lifecycle.AbstractNotificationLifecycle;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.channel.WebChannel;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WebLifecycle
extends AbstractNotificationLifecycle {
    private static final Log LOG = ExoLogger.getLogger(WebLifecycle.class);

    public void process(NotificationContext ctx, String ... userIds) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String pluginId = notification.getKey().getId();
        PluginSettingService pluginSettingService = CommonsUtils.getService(PluginSettingService.class);
        if (!pluginSettingService.isActive("WEB_CHANNEL", pluginId) || notification.isRead()) {
            return;
        }
        PluginConfig pluginConfig = pluginSettingService.getPluginConfig(pluginId);
        UserSettingService userService = CommonsUtils.getService(UserSettingService.class);
        for (String userId : userIds) {
            UserSetting userSetting = userService.get(userId);
            if (userSetting == null || !userSetting.isEnabled() || !userSetting.isChannelGloballyActive("WEB_CHANNEL") || !userSetting.isActive("WEB_CHANNEL", pluginId) || userSetting.isSpaceMuted(notification.getSpaceId()) && pluginConfig.isMutable()) continue;
            NotificationInfo notif = notification.clone(true).setTo(userId).setLastModifiedDate(Calendar.getInstance());
            this.store(notif);
            ctx.setNotificationInfo(notif);
            MessageInfo msg = this.buildMessageInfo(ctx);
            if (msg == null) {
                CommonsUtils.getService(WebNotificationStorage.class).remove(notif.getId());
                continue;
            }
            ctx.append(WebChannel.MESSAGE_INFO, (Object)msg);
            ((MessageInfo)ctx.value(WebChannel.MESSAGE_INFO)).setId(notif.getId());
            this.getChannel().dispatch(ctx, userId);
        }
    }

    public void process(NotificationContext ctx, String userId) {
        LOG.info((Object)("Web Notification process user: " + userId));
    }

    public void store(NotificationInfo notifInfo) {
        AbstractTemplateBuilder builder = this.getChannel().getTemplateBuilder(notifInfo.getKey());
        notifInfo = builder.getNotificationToStore(notifInfo);
        notifInfo.setOnPopOver(true);
        notifInfo.setRead(false);
        CommonsUtils.getService(WebNotificationStorage.class).save(notifInfo);
    }

    public void send(NotificationContext ctx) {
        LOG.info((Object)"WEB:: Send the message by Web channel.");
    }

    private MessageInfo buildMessageInfo(NotificationContext ctx) {
        AbstractTemplateBuilder builder = this.getChannel().getTemplateBuilder(ctx.getNotificationInfo().getKey());
        return builder.buildMessage(ctx);
    }
}

