/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.user;

import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;

@Path(value="/state/")
public class UserStateServiceREST
implements ResourceContainer {
    private final UserStateService userService;

    public UserStateServiceREST(UserStateService userService) {
        this.userService = userService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/status")
    @RolesAllowed(value={"users"})
    public Response online() {
        List<UserStateModel> usersOnline = this.userService.online();
        return Response.ok(usersOnline).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/status/{userId}")
    @RolesAllowed(value={"users"})
    public Response getStatus(@PathParam(value="userId") String userId) {
        UserStateModel model = this.userService.getUserState(userId);
        if (model == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)model).build();
    }

    @PUT
    @Path(value="/status")
    @RolesAllowed(value={"users"})
    public Response setStatus(@QueryParam(value="status") String status) {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        this.userService.saveStatus(currentUser, status);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/status/{userId}")
    @RolesAllowed(value={"users"})
    @Deprecated
    public Response setStatus(@PathParam(value="userId") String userId, @QueryParam(value="status") String status) {
        return this.setStatus(status);
    }
}

