/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.info.test;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.test.BasicTestCase;

public class TestProductInformations
extends BasicTestCase {
    private static final String OLD_PRODUCT_INFORMATIONS_FILE = "classpath:/conf/product_old.properties";
    private static final String OLD_VERSION = "1.0";
    private static final String NEW_VERSION = "2.0";
    protected PortalContainer container;
    protected ProductInformations productInformations;
    protected ConfigurationManager configurationManager;
    protected SettingService settingService;

    public void setUp() {
        this.container = PortalContainer.getInstance();
        this.configurationManager = this.getService(ConfigurationManager.class);
        this.settingService = this.getService(SettingService.class);
        InitParams initParams = new InitParams();
        ValueParam fileParam = new ValueParam();
        fileParam.setName("product.versions.declaration.file");
        fileParam.setValue("classpath:/conf/product_new.properties");
        initParams.addParam((Object)fileParam);
        ValueParam wsParam = new ValueParam();
        wsParam.setName("working.worspace.name");
        wsParam.setValue("portal-test");
        initParams.addParam((Object)wsParam);
        this.productInformations = new ProductInformations(this.configurationManager, initParams, this.settingService);
    }

    public void testUnlockInformation() {
        Properties p = new Properties();
        p.setProperty("edition", "edition");
        p.setProperty("number of users", "1");
        p.setProperty("key generation date", "0");
        p.setProperty("delay", "0");
        p.setProperty("productCode", "0");
        p.setProperty("productKey", "0");
        p.setProperty("product.name", "name");
        p.setProperty("product.link", "link");
        this.productInformations.setUnlockInformation(p);
        TestProductInformations.assertEquals((String)this.productInformations.getEdition(), (String)"edition");
        TestProductInformations.assertEquals((String)this.productInformations.getNumberOfUsers(), (String)"1");
        TestProductInformations.assertEquals((String)this.productInformations.getDateOfLicence(), (String)"0");
        TestProductInformations.assertEquals((String)this.productInformations.getDuration(), (String)"0");
        TestProductInformations.assertEquals((String)this.productInformations.getProductCode(), (String)"0");
        TestProductInformations.assertEquals((String)this.productInformations.getProductKey(), (String)"0");
    }

    public void testShouldUpdateProductInformationMapWhenProductInformationExistsInDB() throws Exception {
        Properties properties = new Properties();
        InputStream oldVersionsContent = this.configurationManager.getInputStream(OLD_PRODUCT_INFORMATIONS_FILE);
        properties.load(oldVersionsContent);
        this.productInformations.initProductInformation(properties);
        this.productInformations.storeProductInformation(this.productInformations.getProductInformation());
        this.productInformations.start();
        Map<String, SettingValue> productInformationSettings = this.getProductInformationFromJPA();
        TestProductInformations.assertFalse((boolean)this.productInformations.isFirstRun());
        TestProductInformations.assertNotNull(productInformationSettings);
        TestProductInformations.assertFalse((boolean)productInformationSettings.isEmpty());
        productInformationSettings.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("org.exoplatform")).forEach(entry -> TestProductInformations.assertEquals((String)("'" + (String)entry.getKey() + "' doesn't have an expected value"), (Object)OLD_VERSION, (Object)((SettingValue)entry.getValue()).getValue()));
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousVersion(), (String)OLD_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousRevision(), (String)OLD_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousBuildNumber(), (String)OLD_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousProductName(), (String)"oldName");
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousProductLink(), (String)"oldLink");
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousVersion("org.exoplatform.social"), (String)OLD_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousVersion("org.gatein.portal"), (String)OLD_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getVersion(), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getRevision(), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getBuildNumber(), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getProductName(), (String)"newName");
        TestProductInformations.assertEquals((String)this.productInformations.getProductLink(), (String)"newLink");
        TestProductInformations.assertEquals((String)this.productInformations.getVersion("org.exoplatform.social"), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getVersion("org.gatein.portal"), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getCurrentProductGroupId(), (String)"io.meeds.commons");
        this.settingService.remove(Context.GLOBAL, Scope.APPLICATION.id("ProductInformation"));
        Map<String, SettingValue> productInformationStgs = this.getProductInformationFromJPA();
        TestProductInformations.assertTrue((boolean)productInformationStgs.isEmpty());
    }

    public void testShouldStoreProductInformationInJPAWhenStartedWithEmptyDB() throws Exception {
        this.productInformations.start();
        Map<String, SettingValue> productInformationSettings = this.getProductInformationFromJPA();
        TestProductInformations.assertTrue((boolean)this.productInformations.isFirstRun());
        TestProductInformations.assertNotNull(productInformationSettings);
        TestProductInformations.assertFalse((boolean)productInformationSettings.isEmpty());
        productInformationSettings.entrySet().stream().filter(entry -> !"product.groupId".equals(entry.getKey()) && !"product.name".equals(entry.getKey()) && !"product.link".equals(entry.getKey())).forEach(entry -> TestProductInformations.assertEquals((Object)((SettingValue)entry.getValue()).getValue(), (Object)NEW_VERSION));
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousVersion(), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousRevision(), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousBuildNumber(), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousVersion("org.exoplatform.social"), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getPreviousVersion("org.gatein.portal"), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getVersion(), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getRevision(), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getBuildNumber(), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getVersion("org.exoplatform.social"), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getVersion("org.gatein.portal"), (String)NEW_VERSION);
        TestProductInformations.assertEquals((String)this.productInformations.getCurrentProductGroupId(), (String)"io.meeds.commons");
        this.settingService.remove(Context.GLOBAL, Scope.APPLICATION.id("ProductInformation"));
        Map<String, SettingValue> productInformationStgs = this.getProductInformationFromJPA();
        TestProductInformations.assertTrue((boolean)productInformationStgs.isEmpty());
    }

    protected <T> T getService(Class<T> clazz) {
        return clazz.cast(this.container.getComponentInstanceOfType(clazz));
    }

    private Map<String, SettingValue> getProductInformationFromJPA() {
        return this.settingService.getSettingsByContextAndScope(Context.GLOBAL.getName(), Context.GLOBAL.getId(), Scope.APPLICATION.getName(), "ProductInformation");
    }
}

