/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.database.creator.DBConnectionInfo;
import org.exoplatform.services.database.creator.DBCreator;
import org.exoplatform.services.naming.InitialContextInitializer;

public class TestDBCreator
extends TestCase {
    protected DBCreator dbCreator;
    private InitialContextInitializer initContext;
    private PortalContainer container;

    public void setUp() throws Exception {
        this.container = PortalContainer.getInstance();
        this.dbCreator = (DBCreator)this.container.getComponentInstanceOfType(DBCreator.class);
        this.initContext = (InitialContextInitializer)this.container.getComponentInstanceOfType(InitialContextInitializer.class);
    }

    public void testDBCreate() throws Exception {
        TestDBCreator.assertNotNull((Object)this.dbCreator);
        DBConnectionInfo dbInfo = this.dbCreator.createDatabase("testdb");
        DBConnectionInfo dbInfo1 = this.dbCreator.getDBConnectionInfo("testdb");
        Map connProps = dbInfo.getProperties();
        Map connProps1 = dbInfo1.getProperties();
        TestDBCreator.assertEquals((String)((String)connProps.get("driverClassName")), (String)((String)connProps1.get("driverClassName")));
        TestDBCreator.assertEquals((String)((String)connProps.get("username")), (String)((String)connProps1.get("username")));
        TestDBCreator.assertEquals((String)((String)connProps.get("url")), (String)((String)connProps1.get("url")));
        TestDBCreator.assertEquals((String)((String)connProps.get("password")), (String)((String)connProps1.get("password")));
        Map refAddr = dbInfo.getProperties();
        this.initContext.getInitialContextBinder().bind("testjdbcjcr", "javax.sql.DataSource", "org.apache.commons.dbcp.BasicDataSourceFactory", null, refAddr);
        DataSource ds = (DataSource)this.initContext.getInitialContext().lookup("testjdbcjcr");
        TestDBCreator.assertNotNull((Object)ds);
        Connection conn = ds.getConnection();
        TestDBCreator.assertNotNull((Object)conn);
    }

    public void testDBCreateWithSpecificProperties() throws Exception {
        TestDBCreator.assertNotNull((Object)this.dbCreator);
        String serverUrl = "jdbc:hsqldb:file:target/temp/data/dbcreator_test";
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        connectionProperties.put("driverClassName", "org.hsqldb.jdbcDriver");
        connectionProperties.put("username", "sa");
        connectionProperties.put("password", "");
        ConfigurationManager cm = (ConfigurationManager)this.container.getComponentInstanceOfType(ConfigurationManager.class);
        DBCreator dbCreator = new DBCreator(serverUrl, connectionProperties, "classpath:/dbcreator/test.sql", "sa", "", cm);
        DBConnectionInfo dbInfo = dbCreator.createDatabase("testdb");
        DBConnectionInfo dbInfo1 = dbCreator.getDBConnectionInfo("testdb");
        Map connProps = dbInfo.getProperties();
        Map connProps1 = dbInfo1.getProperties();
        TestDBCreator.assertEquals((String)((String)connProps.get("driverClassName")), (String)((String)connProps1.get("driverClassName")));
        TestDBCreator.assertEquals((String)((String)connProps.get("username")), (String)((String)connProps1.get("username")));
        TestDBCreator.assertEquals((String)((String)connProps.get("url")), (String)((String)connProps1.get("url")));
        TestDBCreator.assertEquals((String)((String)connProps.get("password")), (String)((String)connProps1.get("password")));
        Map refAddr = dbInfo.getProperties();
        this.initContext.getInitialContextBinder().bind("testjdbcjcr2", "javax.sql.DataSource", "org.apache.commons.dbcp.BasicDataSourceFactory", null, refAddr);
        DataSource ds = (DataSource)this.initContext.getInitialContext().lookup("testjdbcjcr2");
        TestDBCreator.assertNotNull((Object)ds);
        Connection conn = ds.getConnection();
        TestDBCreator.assertNotNull((Object)conn);
    }

    public void testDBCreateMultiThread() throws Exception {
        int i;
        DBCreateThread[] queue = new DBCreateThread[100];
        for (i = 0; i < queue.length; ++i) {
            queue[i] = new DBCreateThread(i);
            queue[i].start();
        }
        for (i = 0; i < queue.length; ++i) {
            queue[i].join();
        }
        for (i = 0; i < queue.length; ++i) {
            DataSource ds = (DataSource)this.initContext.getInitialContext().lookup("testjdbcjcr_" + i);
            TestDBCreator.assertNotNull((Object)ds);
            Connection conn = ds.getConnection();
            TestDBCreator.assertNotNull((Object)conn);
        }
    }

    class DBCreateThread
    extends Thread {
        private final int threadNumber;

        DBCreateThread(int threadNumber) {
            this.threadNumber = threadNumber;
        }

        @Override
        public void run() {
            try {
                DBConnectionInfo dbInfo = TestDBCreator.this.dbCreator.createDatabase("testdb_" + this.threadNumber);
                Map refAddr = dbInfo.getProperties();
                TestDBCreator.this.initContext.getInitialContextBinder().bind("testjdbcjcr_" + this.threadNumber, "javax.sql.DataSource", "org.apache.commons.dbcp.BasicDataSourceFactory", null, refAddr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

