/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.script.groovy.jarjar;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.exoplatform.services.script.groovy.jarjar.JarJarClassLoader;
import org.exoplatform.services.script.groovy.jarjar.Mapping;

public class TestScript {
    private final String name;

    public TestScript(String name) {
        this.name = name;
    }

    public Object execute(Mapping mapping) {
        GroovyObject testObject;
        GroovyCodeSource gcs;
        JarJarClassLoader loader = JarJarClassLoader.createJarJarClassLoaderInPrivilegedMode((ClassLoader)Thread.currentThread().getContextClassLoader());
        mapping.configure(loader);
        URL url = Thread.currentThread().getContextClassLoader().getResource("jarjar/" + this.name);
        Assert.assertNotNull((Object)url);
        try {
            gcs = new GroovyCodeSource(url);
        }
        catch (Exception e) {
            AssertionFailedError err = new AssertionFailedError();
            err.initCause((Throwable)e);
            throw err;
        }
        Class testClass = loader.parseClass(gcs);
        try {
            testObject = (GroovyObject)testClass.newInstance();
        }
        catch (Exception e) {
            AssertionFailedError err = new AssertionFailedError();
            err.initCause((Throwable)e);
            throw err;
        }
        return testObject.invokeMethod("run", (Object)new Object[0]);
    }
}

